/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.util;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.opentsdb.client.bean.response.ErrorResponse;
import org.opentsdb.client.common.Json;
import org.opentsdb.client.exception.http.HttpException;

public class ResponseUtil {
    public static String getContent(HttpResponse response) throws IOException {
        if (ResponseUtil.checkGT400(response)) {
            throw new HttpException(ResponseUtil.convert(response));
        }
        return ResponseUtil.getContentString(response);
    }

    private static String getContentString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
        }
        return null;
    }

    private static boolean checkGT400(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        return statusCode >= 400;
    }

    private static ErrorResponse convert(HttpResponse response) throws IOException {
        return Json.readValue(ResponseUtil.getContentString(response), ErrorResponse.class);
    }
}

