/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.sender.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opentsdb.client.OpenTSDBConfig;
import org.opentsdb.client.bean.request.Api;
import org.opentsdb.client.bean.request.Point;
import org.opentsdb.client.common.Json;
import org.opentsdb.client.http.HttpClient;
import org.opentsdb.client.http.callback.BatchPutHttpResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerRunnable.class);
    private final BlockingQueue<Point> queue;
    private final HttpClient httpClient;
    private final OpenTSDBConfig config;
    private final CountDownLatch countDownLatch;
    private BatchPutHttpResponseCallback.BatchPutCallBack callBack;
    private int batchSize;
    private int batchPutTimeLimit;

    public ConsumerRunnable(BlockingQueue<Point> queue, HttpClient httpClient, OpenTSDBConfig config, CountDownLatch countDownLatch) {
        this.queue = queue;
        this.httpClient = httpClient;
        this.config = config;
        this.countDownLatch = countDownLatch;
        this.batchSize = config.getBatchPutSize();
        this.batchPutTimeLimit = config.getBatchPutTimeLimit();
        this.callBack = config.getBatchPutCallBack();
    }

    @Override
    public void run() {
        log.debug("thread:{} has started take point from queue", (Object)Thread.currentThread().getName());
        Point waitPoint = null;
        boolean readyClose = false;
        int waitTimeLimit = this.batchPutTimeLimit / 3;
        while (!readyClose) {
            long t0 = System.currentTimeMillis();
            ArrayList<Point> pointList = new ArrayList<Point>(this.batchSize);
            if (waitPoint != null) {
                pointList.add(waitPoint);
                waitPoint = null;
            }
            for (int i = pointList.size(); i < this.batchSize; ++i) {
                try {
                    long t1;
                    Point point = this.queue.poll(waitTimeLimit, TimeUnit.MILLISECONDS);
                    if (point != null) {
                        pointList.add(point);
                    }
                    if ((t1 = System.currentTimeMillis()) - t0 <= (long)this.batchPutTimeLimit) continue;
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    log.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
                break;
            }
            if (pointList.size() == 0 && !readyClose) {
                try {
                    waitPoint = this.queue.take();
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    log.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
                continue;
            }
            if (pointList.size() == 0) continue;
            this.sendHttp(pointList);
        }
        this.countDownLatch.countDown();
    }

    private void sendHttp(List<Point> points) {
        try {
            if (this.callBack == null) {
                this.httpClient.post(Api.PUT.getPath(), Json.writeValueAsString(points), new BatchPutHttpResponseCallback());
            } else {
                this.httpClient.post(Api.PUT_DETAIL.getPath(), Json.writeValueAsString(points), new BatchPutHttpResponseCallback(this.callBack, points));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

