/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.http.callback;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.opentsdb.client.bean.request.Query;
import org.opentsdb.client.bean.response.QueryResult;
import org.opentsdb.client.common.Json;
import org.opentsdb.client.exception.http.HttpException;
import org.opentsdb.client.util.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(QueryHttpResponseCallback.class);
    private final QueryCallback callback;
    private final Query query;

    public QueryHttpResponseCallback(QueryCallback callback, Query query) {
        this.callback = callback;
        this.query = query;
    }

    public void completed(HttpResponse response) {
        try {
            List results = (List)Json.readValue(ResponseUtil.getContent(response), List.class, QueryResult.class);
            log.debug("\u8bf7\u6c42\u6210\u529f");
            this.callback.response(this.query, results);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.callback.failed(this.query, e);
        }
        catch (HttpException e) {
            log.error("\u8bf7\u6c42\u5931\u8d25\uff0cquery:{},error:{}", (Object)this.query, (Object)e.getMessage());
            e.printStackTrace();
            this.callback.responseError(this.query, e);
        }
    }

    public void failed(Exception e) {
        log.error("\u8bf7\u6c42\u5931\u8d25\uff0cquery:{},error:{}", (Object)this.query, (Object)e.getMessage());
        this.callback.failed(this.query, e);
    }

    public void cancelled() {
    }

    public static interface QueryCallback {
        public void response(Query var1, List<QueryResult> var2);

        public void responseError(Query var1, HttpException var2);

        public void failed(Query var1, Exception var2);
    }
}

