/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.http.callback;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulCloseFutureCallBack
implements FutureCallback<HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(GracefulCloseFutureCallBack.class);
    private final AtomicInteger unCompletedTaskNum;
    private final FutureCallback<HttpResponse> futureCallback;

    public GracefulCloseFutureCallBack(AtomicInteger unCompletedTaskNum, FutureCallback<HttpResponse> futureCallback) {
        this.unCompletedTaskNum = unCompletedTaskNum;
        this.futureCallback = futureCallback;
    }

    public void completed(HttpResponse result) {
        this.futureCallback.completed((Object)result);
        log.debug("\u7b49\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\u6570:{}", (Object)this.unCompletedTaskNum.decrementAndGet());
    }

    public void failed(Exception ex) {
        this.futureCallback.failed(ex);
        log.debug("\u7b49\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\u6570:{}", (Object)this.unCompletedTaskNum.decrementAndGet());
    }

    public void cancelled() {
        this.futureCallback.cancelled();
        log.debug("\u7b49\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\u6570:{}", (Object)this.unCompletedTaskNum.decrementAndGet());
    }
}

