/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.http.callback;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.opentsdb.client.bean.request.Point;
import org.opentsdb.client.bean.response.DetailResult;
import org.opentsdb.client.common.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPutHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(BatchPutHttpResponseCallback.class);
    private BatchPutCallBack callBack;
    private List<Point> points;

    public BatchPutHttpResponseCallback() {
    }

    public BatchPutHttpResponseCallback(BatchPutCallBack callBack, List<Point> points) {
        this.callBack = callBack;
        this.points = points;
    }

    public void completed(HttpResponse response) {
        HttpEntity entity;
        if (this.callBack != null && (entity = response.getEntity()) != null) {
            try {
                String content = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
                DetailResult detailResult = Json.readValue(content, DetailResult.class);
                if (detailResult.getFailed() == 0) {
                    log.debug("\u6279\u91cf\u6dfb\u52a0\u9519\u8bef\u6570\u91cf\u4e3a0\uff0c\u5168\u90e8\u6210\u529f");
                    this.callBack.response(this.points, detailResult);
                } else {
                    log.debug("\u6279\u91cf\u6dfb\u52a0\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4e2a\u6570:{}", (Object)detailResult.getFailed());
                    this.callBack.responseError(this.points, detailResult);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void failed(Exception e) {
        if (this.callBack != null) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u8bf7\u6c42\u5931\u8d25,error:{}", (Object)e.getMessage());
            this.callBack.failed(this.points, e);
        }
    }

    public void cancelled() {
    }

    public static interface BatchPutCallBack {
        public void response(List<Point> var1, DetailResult var2);

        public void responseError(List<Point> var1, DetailResult var2);

        public void failed(List<Point> var1, Exception var2);
    }
}

