/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.http;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.opentsdb.client.OpenTSDBConfig;
import org.opentsdb.client.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final AtomicInteger NUM = new AtomicInteger();

    public static HttpClient createHttpClient(OpenTSDBConfig config) throws IOReactorException {
        Objects.requireNonNull(config);
        ConnectingIOReactor ioReactor = HttpClientFactory.initIOReactorConfig();
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioReactor);
        RequestConfig requestConfig = HttpClientFactory.initRequestConfig(config);
        CloseableHttpAsyncClient httpAsyncClient = HttpClientFactory.createPoolingHttpClient(requestConfig, connManager);
        return new HttpClient(config, httpAsyncClient, HttpClientFactory.initFixedCycleCloseConnection(connManager));
    }

    private static ConnectingIOReactor initIOReactorConfig() throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        return ioReactor;
    }

    private static RequestConfig initRequestConfig(OpenTSDBConfig config) {
        return RequestConfig.custom().setConnectTimeout(config.getHttpConnectTimeout() * 1000).setSocketTimeout(config.getHttpConnectTimeout() * 1000).setConnectionRequestTimeout(config.getHttpConnectTimeout() * 1000).build();
    }

    private static ConnectionKeepAliveStrategy myStrategy() {
        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 60000L;
            }
        };
        return myStrategy;
    }

    private static CloseableHttpAsyncClient createPoolingHttpClient(RequestConfig config, PoolingNHttpClientConnectionManager cm) {
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(100);
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)cm).setKeepAliveStrategy(HttpClientFactory.myStrategy()).setDefaultRequestConfig(config).build();
        return client;
    }

    private static ScheduledExecutorService initFixedCycleCloseConnection(final PoolingNHttpClientConnectionManager cm) {
        ScheduledExecutorService connectionGcService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "Fixed-Cycle-Close-Connection-" + NUM.incrementAndGet());
            t.setDaemon(true);
            return t;
        });
        connectionGcService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug("Close idle connections, fixed cycle operation");
                    cm.closeExpiredConnections();
                    cm.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        return connectionGcService;
    }

    public static class OpenTSDBConnectionReuseStrategy
    implements ConnectionReuseStrategy {
        public boolean keepAlive(HttpResponse response, HttpContext context) {
            return false;
        }
    }

    public static class OpenTSDBConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private long time;

        public OpenTSDBConnectionKeepAliveStrategy(long time) {
            this.time = time;
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            return 1000L * this.time;
        }
    }
}

