/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class Json {
    private static final ObjectMapper instance = new ObjectMapper();

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return instance.writeValueAsString(value);
    }

    public static <T> T readValue(String content, Class<T> valueType) throws IOException {
        return (T)instance.readValue(content, valueType);
    }

    public static <T> T readValue(String content, Class<? extends Collection> collectionClass, Class<?> elementClass) throws IOException {
        CollectionType collectionType = instance.getTypeFactory().constructCollectionType(collectionClass, elementClass);
        return (T)instance.readValue(content, (JavaType)collectionType);
    }

    static {
        instance.registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module());
        instance.findAndRegisterModules();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        instance.setDateFormat((DateFormat)dateFormat);
        instance.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        instance.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        instance.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        instance.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

