/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.bean.request;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SubQuery {
    private Aggregator aggregator;
    private String metric;
    private String downsample;
    private Boolean rate;
    private RateOptions rateOptions;
    private Map<String, String> tags;
    private Boolean explicitTags;
    private String rollupUsage;
    private List<Filter> filters;

    public static MetricBuilder metric(String metric) {
        return new MetricBuilder(metric);
    }

    public static AggregatorBuilder aggregator(Aggregator aggregator) {
        return new AggregatorBuilder(aggregator);
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getDownsample() {
        return this.downsample;
    }

    public Boolean getRate() {
        return this.rate;
    }

    public RateOptions getRateOptions() {
        return this.rateOptions;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean getExplicitTags() {
        return this.explicitTags;
    }

    public String getRollupUsage() {
        return this.rollupUsage;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setDownsample(String downsample) {
        this.downsample = downsample;
    }

    public void setRate(Boolean rate) {
        this.rate = rate;
    }

    public void setRateOptions(RateOptions rateOptions) {
        this.rateOptions = rateOptions;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setExplicitTags(Boolean explicitTags) {
        this.explicitTags = explicitTags;
    }

    public void setRollupUsage(String rollupUsage) {
        this.rollupUsage = rollupUsage;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubQuery)) {
            return false;
        }
        SubQuery other = (SubQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Aggregator this$aggregator = this.getAggregator();
        Aggregator other$aggregator = other.getAggregator();
        if (this$aggregator == null ? other$aggregator != null : !((Object)((Object)this$aggregator)).equals((Object)other$aggregator)) {
            return false;
        }
        String this$metric = this.getMetric();
        String other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        String this$downsample = this.getDownsample();
        String other$downsample = other.getDownsample();
        if (this$downsample == null ? other$downsample != null : !this$downsample.equals(other$downsample)) {
            return false;
        }
        Boolean this$rate = this.getRate();
        Boolean other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        RateOptions this$rateOptions = this.getRateOptions();
        RateOptions other$rateOptions = other.getRateOptions();
        if (this$rateOptions == null ? other$rateOptions != null : !((Object)this$rateOptions).equals(other$rateOptions)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Boolean this$explicitTags = this.getExplicitTags();
        Boolean other$explicitTags = other.getExplicitTags();
        if (this$explicitTags == null ? other$explicitTags != null : !((Object)this$explicitTags).equals(other$explicitTags)) {
            return false;
        }
        String this$rollupUsage = this.getRollupUsage();
        String other$rollupUsage = other.getRollupUsage();
        if (this$rollupUsage == null ? other$rollupUsage != null : !this$rollupUsage.equals(other$rollupUsage)) {
            return false;
        }
        List<Filter> this$filters = this.getFilters();
        List<Filter> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Aggregator $aggregator = this.getAggregator();
        result = result * 59 + ($aggregator == null ? 43 : ((Object)((Object)$aggregator)).hashCode());
        String $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        String $downsample = this.getDownsample();
        result = result * 59 + ($downsample == null ? 43 : $downsample.hashCode());
        Boolean $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        RateOptions $rateOptions = this.getRateOptions();
        result = result * 59 + ($rateOptions == null ? 43 : ((Object)$rateOptions).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Boolean $explicitTags = this.getExplicitTags();
        result = result * 59 + ($explicitTags == null ? 43 : ((Object)$explicitTags).hashCode());
        String $rollupUsage = this.getRollupUsage();
        result = result * 59 + ($rollupUsage == null ? 43 : $rollupUsage.hashCode());
        List<Filter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "SubQuery(aggregator=" + (Object)((Object)this.getAggregator()) + ", metric=" + this.getMetric() + ", downsample=" + this.getDownsample() + ", rate=" + this.getRate() + ", rateOptions=" + this.getRateOptions() + ", tags=" + this.getTags() + ", explicitTags=" + this.getExplicitTags() + ", rollupUsage=" + this.getRollupUsage() + ", filters=" + this.getFilters() + ")";
    }

    public static class Filter {
        private FilterType type;
        private String tagk;
        private String filter;
        private Boolean groupBy;

        public static Builder filter(FilterType type, String tagk, String filter) {
            return new Builder(type, tagk, filter);
        }

        public static Builder filter(FilterType type, String tagk, String filter, Boolean groupBy) {
            return new Builder(type, tagk, filter, groupBy);
        }

        public static Builder filter(FilterType type, String filter) {
            return new Builder(type, null, filter);
        }

        public FilterType getType() {
            return this.type;
        }

        public String getTagk() {
            return this.tagk;
        }

        public String getFilter() {
            return this.filter;
        }

        public Boolean getGroupBy() {
            return this.groupBy;
        }

        public void setType(FilterType type) {
            this.type = type;
        }

        public void setTagk(String tagk) {
            this.tagk = tagk;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public void setGroupBy(Boolean groupBy) {
            this.groupBy = groupBy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FilterType this$type = this.getType();
            FilterType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$tagk = this.getTagk();
            String other$tagk = other.getTagk();
            if (this$tagk == null ? other$tagk != null : !this$tagk.equals(other$tagk)) {
                return false;
            }
            String this$filter = this.getFilter();
            String other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
                return false;
            }
            Boolean this$groupBy = this.getGroupBy();
            Boolean other$groupBy = other.getGroupBy();
            return !(this$groupBy == null ? other$groupBy != null : !((Object)this$groupBy).equals(other$groupBy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Filter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FilterType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $tagk = this.getTagk();
            result = result * 59 + ($tagk == null ? 43 : $tagk.hashCode());
            String $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
            Boolean $groupBy = this.getGroupBy();
            result = result * 59 + ($groupBy == null ? 43 : ((Object)$groupBy).hashCode());
            return result;
        }

        public String toString() {
            return "SubQuery.Filter(type=" + (Object)((Object)this.getType()) + ", tagk=" + this.getTagk() + ", filter=" + this.getFilter() + ", groupBy=" + this.getGroupBy() + ")";
        }

        public static enum FilterType {
            REGEXP("regexp"),
            IWILDCARD("iwildcard"),
            ILITERAL_OR("iliteral_or"),
            NOT_ILITERAL_OR("not_iliteral_or"),
            NOT_LITERAL_OR("not_literal_or"),
            LITERAL_OR("literal_or");

            private String name;

            private FilterType(String name) {
                this.name = name;
            }

            @JsonValue
            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }

        public static class Builder {
            private FilterType type;
            private String tagk;
            private String filter;
            private Boolean groupBy;

            public Builder(FilterType type, String tagk, String filter, Boolean groupBy) {
                this.type = type;
                this.tagk = tagk;
                this.filter = filter;
                this.groupBy = groupBy;
            }

            public Builder(FilterType type, String tagk, String filter) {
                this.type = type;
                this.tagk = tagk;
                this.filter = filter;
            }

            public Filter build() {
                Filter f = new Filter();
                f.type = this.type;
                f.tagk = this.tagk;
                f.filter = this.filter;
                if (this.groupBy.booleanValue()) {
                    f.groupBy = this.groupBy;
                }
                return f;
            }
        }
    }

    public static class RateOptions {
        private Boolean counter;
        private Boolean dropResets;
        private Long counterMax;
        private Long resetValue;

        public static Builder newBuilder() {
            return new Builder();
        }

        public Boolean getCounter() {
            return this.counter;
        }

        public Boolean getDropResets() {
            return this.dropResets;
        }

        public Long getCounterMax() {
            return this.counterMax;
        }

        public Long getResetValue() {
            return this.resetValue;
        }

        public void setCounter(Boolean counter) {
            this.counter = counter;
        }

        public void setDropResets(Boolean dropResets) {
            this.dropResets = dropResets;
        }

        public void setCounterMax(Long counterMax) {
            this.counterMax = counterMax;
        }

        public void setResetValue(Long resetValue) {
            this.resetValue = resetValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateOptions)) {
                return false;
            }
            RateOptions other = (RateOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$counter = this.getCounter();
            Boolean other$counter = other.getCounter();
            if (this$counter == null ? other$counter != null : !((Object)this$counter).equals(other$counter)) {
                return false;
            }
            Boolean this$dropResets = this.getDropResets();
            Boolean other$dropResets = other.getDropResets();
            if (this$dropResets == null ? other$dropResets != null : !((Object)this$dropResets).equals(other$dropResets)) {
                return false;
            }
            Long this$counterMax = this.getCounterMax();
            Long other$counterMax = other.getCounterMax();
            if (this$counterMax == null ? other$counterMax != null : !((Object)this$counterMax).equals(other$counterMax)) {
                return false;
            }
            Long this$resetValue = this.getResetValue();
            Long other$resetValue = other.getResetValue();
            return !(this$resetValue == null ? other$resetValue != null : !((Object)this$resetValue).equals(other$resetValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RateOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $counter = this.getCounter();
            result = result * 59 + ($counter == null ? 43 : ((Object)$counter).hashCode());
            Boolean $dropResets = this.getDropResets();
            result = result * 59 + ($dropResets == null ? 43 : ((Object)$dropResets).hashCode());
            Long $counterMax = this.getCounterMax();
            result = result * 59 + ($counterMax == null ? 43 : ((Object)$counterMax).hashCode());
            Long $resetValue = this.getResetValue();
            result = result * 59 + ($resetValue == null ? 43 : ((Object)$resetValue).hashCode());
            return result;
        }

        public String toString() {
            return "SubQuery.RateOptions(counter=" + this.getCounter() + ", dropResets=" + this.getDropResets() + ", counterMax=" + this.getCounterMax() + ", resetValue=" + this.getResetValue() + ")";
        }

        public static class Builder {
            private Boolean counter;
            private Boolean dropResets;
            private Long counterMax;
            private Long resetValue;

            public Builder counter(boolean counter) {
                this.counter = counter;
                return this;
            }

            public Builder dropResets(boolean dropResets) {
                this.dropResets = dropResets;
                return this;
            }

            public Builder counterMax(long counterMax) {
                this.counterMax = counterMax;
                return this;
            }

            public Builder resetValue(long resetValue) {
                this.resetValue = resetValue;
                return this;
            }

            public RateOptions build() {
                RateOptions rateOptions = new RateOptions();
                if (this.counter != null) {
                    rateOptions.counter = this.counter;
                }
                if (this.dropResets != null) {
                    rateOptions.dropResets = this.dropResets;
                }
                if (this.counterMax != null) {
                    rateOptions.counterMax = this.counterMax;
                }
                if (this.resetValue != null) {
                    rateOptions.resetValue = this.resetValue;
                }
                return rateOptions;
            }
        }
    }

    public static enum Aggregator {
        MULT("mult"),
        P90("p90"),
        ZIMSUM("zimsum"),
        MIMMAX("mimmax"),
        SUM("sum"),
        P50("p50"),
        NONE("none"),
        P95("p95"),
        EP99R7("ep99r7"),
        P75("p75"),
        P99("p99"),
        EP99R3("ep99r3"),
        EP95R7("ep95r7"),
        MIN("min"),
        AVG("avg"),
        EP75R7("ep75r7"),
        DEV("dev"),
        EP95R3("ep95r3"),
        EP75R3("ep75r3"),
        EP50R7("ep50r7"),
        EP90R7("ep90r7"),
        MIMMIN("mimmin"),
        P999("p999"),
        EP50R3("ep50r3"),
        EP90R3("ep90r3"),
        EP999R7("ep999r7"),
        LAST("last"),
        MAX("max"),
        COUNT("count"),
        EP999R3("ep999r3"),
        FIRST("first");

        private static final Map<String, Aggregator> AGG_MAP;
        private String name;

        public static Aggregator getEnum(String name) {
            return AGG_MAP.get(name);
        }

        private Aggregator(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            AGG_MAP = Maps.newHashMapWithExpectedSize((int)Aggregator.values().length);
            for (Aggregator typeEnum : Aggregator.values()) {
                AGG_MAP.put(typeEnum.getName(), typeEnum);
            }
        }
    }

    public static class AggregatorBuilder {
        private Aggregator aggregator;

        public AggregatorBuilder(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        public Builder metric(String metric) {
            return new Builder(metric, this.aggregator);
        }
    }

    public static class MetricBuilder {
        private String metric;

        public MetricBuilder(String metric) {
            this.metric = metric;
        }

        public Builder aggregator(Aggregator aggregator) {
            return new Builder(this.metric, aggregator);
        }
    }

    public static class Builder {
        private Aggregator aggregator;
        private String metric;
        private String downsample;
        private Boolean rate;
        private RateOptions rateOptions;
        private Map<String, String> tags = new HashMap<String, String>();
        private Boolean explicitTags;
        private String rollupUsage;
        private List<Filter> filters = new ArrayList<Filter>();

        public Builder(String metric, Aggregator aggregator) {
            Objects.requireNonNull(metric, "metric");
            Objects.requireNonNull(aggregator, "aggregator");
            this.aggregator = aggregator;
            this.metric = metric;
        }

        public Builder rate() {
            this.rate = true;
            return this;
        }

        public Builder rate(RateOptions rateOptions) {
            this.rate = true;
            this.rateOptions = rateOptions;
            return this;
        }

        public Builder downsample(String downsample) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{downsample})) {
                this.downsample = downsample;
            }
            return this;
        }

        public Builder rollupUsage(String rollupUsage) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rollupUsage})) {
                this.rollupUsage = rollupUsage;
            }
            return this;
        }

        public Builder explicitTags() {
            this.explicitTags = true;
            return this;
        }

        public Builder tag(String tagk, String tagv) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tagk}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tagv})) {
                this.tags.put(tagk, tagv);
            }
            return this;
        }

        public Builder tag(Map<String, String> tags) {
            if (!MapUtils.isEmpty(tags)) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public Builder filter(Filter filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder filter(List<Filter> filterList) {
            if (!CollectionUtils.isEmpty(filterList)) {
                this.filters.addAll(filterList);
            }
            return this;
        }

        public SubQuery build() {
            SubQuery subQuery = new SubQuery();
            subQuery.aggregator = this.aggregator;
            subQuery.downsample = this.downsample;
            subQuery.metric = this.metric;
            subQuery.tags = this.tags;
            subQuery.filters = this.filters;
            subQuery.rate = this.rate;
            subQuery.rateOptions = this.rateOptions;
            subQuery.explicitTags = this.explicitTags;
            subQuery.rollupUsage = this.rollupUsage;
            return subQuery;
        }
    }
}

