/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.bean.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class Point {
    private String metric;
    private Map<String, String> tags = new HashMap<String, String>();
    private Number value;
    private long timestamp;

    public static MetricBuilder metric(String metric) {
        return new MetricBuilder(metric);
    }

    public String getMetric() {
        return this.metric;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Number getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$metric = this.getMetric();
        String other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Number this$value = this.getValue();
        Number other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Number $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public String toString() {
        return "Point(metric=" + this.getMetric() + ", tags=" + this.getTags() + ", value=" + this.getValue() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class MetricBuilder {
        private String metric;
        private Map<String, String> tags = new HashMap<String, String>();
        private Number value;
        private long timestamp;

        public MetricBuilder(String metric) {
            if (StringUtils.isBlank((CharSequence)metric)) {
                throw new IllegalArgumentException("The metric can't be empty");
            }
            this.metric = metric;
        }

        public MetricBuilder value(long timestamp, Number value) {
            if (timestamp == 0L) {
                throw new IllegalArgumentException("timestamp must gt 0");
            }
            Objects.requireNonNull(value);
            this.timestamp = timestamp;
            this.value = value;
            return this;
        }

        public MetricBuilder tag(String tagName, String value) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tagName}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
                this.tags.put(tagName, value);
            }
            return this;
        }

        public MetricBuilder tag(Map<String, String> tags) {
            if (!MapUtils.isEmpty(tags)) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public Point build() {
            Point point = new Point();
            point.metric = this.metric;
            if (MapUtils.isEmpty(this.tags)) {
                throw new IllegalArgumentException("tags can't be empty");
            }
            point.tags = this.tags;
            point.timestamp = this.timestamp;
            point.value = this.value;
            return point;
        }
    }
}

