/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.nio.reactor.IOReactorException;
import org.opentsdb.client.OpenTSDBConfig;
import org.opentsdb.client.bean.request.Api;
import org.opentsdb.client.bean.request.LastPointQuery;
import org.opentsdb.client.bean.request.Point;
import org.opentsdb.client.bean.request.Query;
import org.opentsdb.client.bean.request.SuggestQuery;
import org.opentsdb.client.bean.response.LastPointQueryResult;
import org.opentsdb.client.bean.response.QueryResult;
import org.opentsdb.client.common.Json;
import org.opentsdb.client.http.HttpClient;
import org.opentsdb.client.http.HttpClientFactory;
import org.opentsdb.client.http.callback.QueryHttpResponseCallback;
import org.opentsdb.client.sender.consumer.Consumer;
import org.opentsdb.client.sender.consumer.ConsumerImpl;
import org.opentsdb.client.sender.producer.Producer;
import org.opentsdb.client.sender.producer.ProducerImpl;
import org.opentsdb.client.util.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBClient {
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBClient.class);
    private final OpenTSDBConfig config;
    private final HttpClient httpClient;
    private Producer producer;
    private Consumer consumer;
    private BlockingQueue<Point> queue;
    private static Field queryDeleteField;

    public OpenTSDBClient(OpenTSDBConfig config) throws IOReactorException {
        this.config = config;
        this.httpClient = HttpClientFactory.createHttpClient(config);
        this.httpClient.start();
        if (!config.isReadonly()) {
            this.queue = new ArrayBlockingQueue<Point>(config.getBatchPutBufferSize());
            this.producer = new ProducerImpl(this.queue);
            this.consumer = new ConsumerImpl(this.queue, this.httpClient, config);
            this.consumer.start();
            try {
                queryDeleteField = Query.class.getDeclaredField("delete");
                queryDeleteField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        log.debug("the httpclient has started");
    }

    public List<QueryResult> query(Query query) throws IOException, ExecutionException, InterruptedException {
        Future<HttpResponse> future = this.httpClient.post(Api.QUERY.getPath(), Json.writeValueAsString(query));
        HttpResponse response = future.get();
        List results = (List)Json.readValue(ResponseUtil.getContent(response), List.class, QueryResult.class);
        return results;
    }

    public void query(Query query, QueryHttpResponseCallback.QueryCallback callback) throws JsonProcessingException {
        QueryHttpResponseCallback queryHttpResponseCallback = new QueryHttpResponseCallback(callback, query);
        this.httpClient.post(Api.QUERY.getPath(), Json.writeValueAsString(query), queryHttpResponseCallback);
    }

    public List<LastPointQueryResult> queryLast(LastPointQuery query) throws IOException, ExecutionException, InterruptedException {
        Future<HttpResponse> future = this.httpClient.post(Api.LAST.getPath(), Json.writeValueAsString(query));
        HttpResponse response = future.get();
        List results = (List)Json.readValue(ResponseUtil.getContent(response), List.class, LastPointQueryResult.class);
        return results;
    }

    public void put(Point point) {
        if (this.config.isReadonly()) {
            throw new IllegalArgumentException("this client is readonly,can't put point");
        }
        this.producer.send(point);
    }

    public List<QueryResult> delete(Query query) throws IllegalAccessException, ExecutionException, InterruptedException, IOException {
        if (this.config.isReadonly()) {
            throw new IllegalArgumentException("this client is readonly,can't delete data");
        }
        queryDeleteField.set(query, true);
        Future<HttpResponse> future = this.httpClient.post(Api.QUERY.getPath(), Json.writeValueAsString(query));
        HttpResponse response = future.get();
        List results = (List)Json.readValue(ResponseUtil.getContent(response), List.class, QueryResult.class);
        return results;
    }

    public List<String> querySuggest(SuggestQuery query) throws ExecutionException, InterruptedException, IOException {
        Future<HttpResponse> future = this.httpClient.post(Api.SUGGEST.getPath(), Json.writeValueAsString(query));
        HttpResponse response = future.get();
        List results = (List)Json.readValue(ResponseUtil.getContent(response), List.class, String.class);
        return results;
    }

    public void gracefulClose() throws IOException {
        if (!this.config.isReadonly()) {
            this.producer.forbiddenSend();
            this.waitEmpty();
            this.consumer.gracefulStop();
        }
        this.httpClient.gracefulClose();
    }

    private void waitEmpty() {
        while (!this.queue.isEmpty()) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.config.getBatchPutTimeLimit());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void forceClose() throws IOException {
        if (!this.config.isReadonly()) {
            this.consumer.forceStop();
        }
        this.httpClient.forceClose();
    }
}

