/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.embedded;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.embedded.AbstractEmbeddedNamingStrategyConfigConverter;
import com.github.euler.tika.embedded.MimetypeEmbeddedNamingStrategy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;

public class MimetypeEmbeddedNamingStrategyConfigConverter
extends AbstractEmbeddedNamingStrategyConfigConverter {
    public String configType() {
        return "mime-type";
    }

    public EmbeddedNamingStrategy convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = this.getConfig(config);
        EmbeddedNamingStrategy defaultStrategy = (EmbeddedNamingStrategy)typeConfigConverter.convert("embedded-naming-strategy", config.getValue("default"), configContext);
        Map<String, EmbeddedNamingStrategy> mapping = config.getObject("mapping").entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.convert((ConfigValue)e.getValue(), configContext, typeConfigConverter)));
        return new MimetypeEmbeddedNamingStrategy(defaultStrategy, mapping);
    }

    private EmbeddedNamingStrategy convert(ConfigValue value, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        return (EmbeddedNamingStrategy)typeConfigConverter.convert("embedded-naming-strategy", value, configContext);
    }

    protected Config getConfig(Config config) {
        return ConfigFactory.parseString((String)config.root().render(ConfigRenderOptions.concise())).withFallback((ConfigMergeable)this.getDefaultConfig()).resolve();
    }

    protected Config getDefaultConfig() {
        URL resource = MimetypeEmbeddedNamingStrategyConfigConverter.class.getClassLoader().getResource("mimetypestrategy.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

