/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedStrategy;
import com.github.euler.tika.ParseContextFactory;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;

public class ParseContextFactoryWrapper
implements ParseContextFactory {
    private final Parser parser;
    private final ParseContextFactory wrapped;
    private final EmbeddedStrategy embeddedStrategy;

    public ParseContextFactoryWrapper(Parser parser, ParseContextFactory wrapped, EmbeddedStrategy embeddedStrategy) {
        this.parser = parser;
        this.wrapped = wrapped;
        this.embeddedStrategy = embeddedStrategy;
    }

    @Override
    public ParseContext create(ProcessingContext processingContext) {
        ParseContext ctx = this.wrapped.create(processingContext);
        ctx.set(Parser.class, (Object)this.parser);
        if (this.embeddedStrategy.shouldParseEmbedded(processingContext)) {
            this.embeddedStrategy.setParseContext(ctx);
            ctx.set(EmbeddedDocumentExtractor.class, (Object)this.embeddedStrategy);
        }
        return ctx;
    }
}

