/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.StreamFactory;
import com.github.euler.core.Item;
import com.github.euler.core.ItemProcessor;
import com.github.euler.core.ProcessingContext;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeItemProcessor
implements ItemProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String field;
    private final StreamFactory sf;
    private final Detector detector;

    public MimeTypeItemProcessor(String field, StreamFactory sf, Detector detector) {
        this.field = field;
        this.sf = sf;
        this.detector = detector;
    }

    public MimeTypeItemProcessor(StreamFactory sf, Detector detector) {
        this("mime_type", sf, detector);
    }

    public ProcessingContext process(Item item) {
        Object mimeType = null;
        Boolean isDirectory = (Boolean)item.ctx.metadata("is_directory");
        if (isDirectory != null && isDirectory.booleanValue()) {
            mimeType = "text/directory";
        } else {
            Metadata metadata = new Metadata();
            if (item.ctx.metadata().containsKey("name")) {
                metadata.set("resourceName", item.ctx.metadata("name").toString());
            }
            try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)this.sf.openInputStream(item.itemURI, item.ctx));){
                MediaType type = this.detector.detect((InputStream)tikaInputStream, metadata);
                type = type.getBaseType();
                mimeType = type.getType() + "/" + type.getSubtype();
            }
            catch (Throwable e) {
                this.LOGGER.warn("An error occurred while detecting mime type for {}: {}", (Object)item.itemURI, (Object)e.getMessage());
            }
        }
        return ProcessingContext.builder().metadata(this.field, mimeType).build();
    }
}

