/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.tika.AbstractEmbeddedStrategyFactoryConfigConverter;
import com.github.euler.tika.DefaultEmbeddedStrategyFactory;
import com.github.euler.tika.EmbeddedStrategyFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.net.URL;
import java.util.List;
import org.apache.tika.detect.Detector;

public class DefaultEmbeddedStrategyFactoryConfigConverter
extends AbstractEmbeddedStrategyFactoryConfigConverter {
    public String configType() {
        return "default";
    }

    public EmbeddedStrategyFactory convert(Config config, ConfigContext ctx, TypesConfigConverter typeConfigConverter) {
        config = this.getConfig(config);
        Detector detector = (Detector)ctx.getRequired(Detector.class);
        int maxDepth = config.getInt("max-depth");
        List<String> includeParseEmbeddedRegex = this.getListOrString("parse.include-regex", config);
        List<String> excludeParseEmbeddedRegex = this.getListOrString("parse.exclude-regex", config);
        List<String> includeExtractEmbeddedRegex = this.getListOrString("extract.include-regex", config);
        List<String> excludeExtractEmbeddedRegex = this.getListOrString("extract.exclude-regex", config);
        String mimeTypeField = config.getString("mime-type-field");
        boolean outputName = config.getBoolean("output-name");
        return new DefaultEmbeddedStrategyFactory(detector, maxDepth, includeParseEmbeddedRegex, excludeParseEmbeddedRegex, includeExtractEmbeddedRegex, excludeExtractEmbeddedRegex, mimeTypeField, outputName);
    }

    protected Config getConfig(Config config) {
        return ConfigFactory.parseString((String)config.root().render(ConfigRenderOptions.concise())).withFallback((ConfigMergeable)this.getDefaultConfig()).resolve();
    }

    private List<String> getListOrString(String path, Config config) {
        try {
            return List.of(config.getString(path));
        }
        catch (ConfigException.WrongType e) {
            return config.getStringList(path);
        }
    }

    protected Config getDefaultConfig() {
        URL resource = DefaultEmbeddedStrategyFactoryConfigConverter.class.getClassLoader().getResource("defaultembeddedstrategy.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

