/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.embedded;

import com.github.euler.common.CommonContext;
import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.RandomStringGenerator;
import com.github.slugify.Slugify;
import java.net.URI;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.metadata.Metadata;

public class RFC822EmbeddedNamingStrategy
implements EmbeddedNamingStrategy {
    private final Pattern identifierPattern;
    private final Slugify slg = new Slugify();
    private final RandomStringGenerator randomGenerator = new RandomStringGenerator();

    public RFC822EmbeddedNamingStrategy(String identifierRegex) {
        this.identifierPattern = Pattern.compile(identifierRegex);
    }

    @Override
    public String nameEmbedded(URI parentURI, ProcessingContext parentContext, Metadata embeddedMetadata) {
        String random = this.randomGenerator.generate(5);
        String parentId = this.getParentId(parentURI, parentContext);
        String subject = this.getSubject(embeddedMetadata);
        String identifier = this.getIdentifier(embeddedMetadata);
        String name = this.slg.slugify(random + "_" + parentId + "_" + identifier + "_" + subject);
        return name + ".eml";
    }

    private String getParentId(URI parentURI, ProcessingContext parentContext) {
        return (String)parentContext.context(CommonContext.ID, () -> this.generateId(parentURI, parentContext));
    }

    private String generateId(URI uri, ProcessingContext ctx) {
        return DigestUtils.md5Hex((String)uri.normalize().toString()).toLowerCase();
    }

    protected String getSubject(Metadata embeddedMetadata) {
        String subject = embeddedMetadata.get("subject");
        if (subject.length() > 20) {
            subject = subject.substring(0, 20);
        }
        return subject;
    }

    protected String getIdentifier(Metadata embeddedMetadata) {
        Matcher matcher;
        String identifier = embeddedMetadata.get("identifier");
        identifier = identifier != null ? ((matcher = this.identifierPattern.matcher(identifier.trim())).find() ? matcher.group(1) : UUID.randomUUID().toString()) : UUID.randomUUID().toString();
        return identifier;
    }
}

