/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.tika.DefaultEmbeddedStrategy;
import com.github.euler.tika.EmbeddedItemListener;
import com.github.euler.tika.EmbeddedStrategy;
import com.github.euler.tika.EmbeddedStrategyFactory;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultEmbeddedStrategyFactory
implements EmbeddedStrategyFactory {
    private final int maxDepth;
    private final List<Pattern> includeParseEmbeddedPatterns;
    private final List<Pattern> excludeParseEmbeddedPatterns;
    private final List<Pattern> includeExtractEmbeddedPatterns;
    private final List<Pattern> excludeExtractEmbeddedPatterns;
    private final String mimeTypeField;
    private final boolean outputName;

    public DefaultEmbeddedStrategyFactory(int maxDepth, List<String> includeParseEmbeddedRegex, List<String> excludeParseEmbeddedRegex, List<String> includeExtractEmbeddedRegex, List<String> excludeExtractEmbeddedRegex, String mimeTypeField, boolean outputName) {
        this.maxDepth = maxDepth;
        this.includeParseEmbeddedPatterns = this.toPattern(includeParseEmbeddedRegex);
        this.excludeParseEmbeddedPatterns = this.toPattern(excludeParseEmbeddedRegex);
        this.includeExtractEmbeddedPatterns = this.toPattern(includeExtractEmbeddedRegex);
        this.excludeExtractEmbeddedPatterns = this.toPattern(excludeExtractEmbeddedRegex);
        this.mimeTypeField = mimeTypeField;
        this.outputName = outputName;
    }

    private List<Pattern> toPattern(List<String> regex) {
        return Collections.unmodifiableList(regex.stream().map(r -> Pattern.compile(r)).collect(Collectors.toList()));
    }

    @Override
    public EmbeddedStrategy newEmbeddedStrategy(EmbeddedItemListener listener) {
        DefaultEmbeddedStrategy strategy = new DefaultEmbeddedStrategy(this.maxDepth, this.includeParseEmbeddedPatterns, this.excludeParseEmbeddedPatterns, this.includeExtractEmbeddedPatterns, this.excludeExtractEmbeddedPatterns, this.mimeTypeField, this.outputName);
        strategy.setListener(listener);
        return strategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int maxDepth = 10;
        private List<String> includeParseEmbeddedRegex = List.of(".+");
        private List<String> excludeParseEmbeddedRegex = List.of("a^");
        private List<String> includeExtractEmbeddedRegex = List.of("a^");
        private List<String> excludeExtractEmbeddedRegex = List.of("a^");
        private String mimeTypeField = "mime_type";
        private boolean outputName = false;

        private Builder() {
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public Builder setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public List<String> getIncludeParseEmbeddedRegex() {
            return this.includeParseEmbeddedRegex;
        }

        public Builder setIncludeParseEmbeddedRegex(List<String> includeParseEmbeddedRegex) {
            this.includeParseEmbeddedRegex = includeParseEmbeddedRegex;
            return this;
        }

        public Builder setIncludeParseEmbeddedRegex(String includeParseEmbeddedRegex) {
            this.includeParseEmbeddedRegex = List.of(includeParseEmbeddedRegex);
            return this;
        }

        public List<String> getExcludeParseEmbeddedRegex() {
            return this.excludeParseEmbeddedRegex;
        }

        public Builder setExcludeParseEmbeddedRegex(List<String> excludeParseEmbeddedRegex) {
            this.excludeParseEmbeddedRegex = excludeParseEmbeddedRegex;
            return this;
        }

        public Builder setExcludeParseEmbeddedRegex(String excludeParseEmbeddedRegex) {
            this.excludeParseEmbeddedRegex = List.of(excludeParseEmbeddedRegex);
            return this;
        }

        public List<String> getIncludeExtractEmbeddedRegex() {
            return this.includeExtractEmbeddedRegex;
        }

        public Builder setIncludeExtractEmbeddedRegex(List<String> includeExtractEmbeddedRegex) {
            this.includeExtractEmbeddedRegex = includeExtractEmbeddedRegex;
            return this;
        }

        public Builder setIncludeExtractEmbeddedRegex(String includeExtractEmbeddedRegex) {
            this.includeExtractEmbeddedRegex = List.of(includeExtractEmbeddedRegex);
            return this;
        }

        public List<String> getExcludeExtractEmbeddedRegex() {
            return this.excludeExtractEmbeddedRegex;
        }

        public Builder setExcludeExtractEmbeddedRegex(List<String> excludeExtractEmbeddedRegex) {
            this.excludeExtractEmbeddedRegex = excludeExtractEmbeddedRegex;
            return this;
        }

        public Builder setExcludeExtractEmbeddedRegex(String excludeExtractEmbeddedRegex) {
            this.excludeExtractEmbeddedRegex = List.of(excludeExtractEmbeddedRegex);
            return this;
        }

        public String getMimeTypeField() {
            return this.mimeTypeField;
        }

        public Builder setMimeTypeField(String mimeTypeField) {
            this.mimeTypeField = mimeTypeField;
            return this;
        }

        public boolean isOutputName() {
            return this.outputName;
        }

        public Builder setOutputName(boolean outputName) {
            this.outputName = outputName;
            return this;
        }

        public DefaultEmbeddedStrategyFactory build() {
            return new DefaultEmbeddedStrategyFactory(this.maxDepth, this.includeParseEmbeddedRegex, this.excludeParseEmbeddedRegex, this.includeExtractEmbeddedRegex, this.excludeExtractEmbeddedRegex, this.mimeTypeField, this.outputName);
        }
    }
}

