/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.embedded;

import com.github.euler.common.CommonContext;
import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.RandomStringGenerator;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;

public class DefaultEmbeddedNamingStrategy
implements EmbeddedNamingStrategy {
    private final RandomStringGenerator randomGenerator = new RandomStringGenerator();

    @Override
    public String nameEmbedded(URI parentURI, ProcessingContext parentContext, Metadata embeddedMetadata) {
        String resourceName = embeddedMetadata.get("resourceName");
        if (resourceName == null) {
            return "embedded_" + UUID.randomUUID().toString().toLowerCase();
        }
        String random = this.randomGenerator.generate(5);
        String parentId = this.getParentId(parentURI, parentContext);
        return random + "_" + parentId + "_" + FilenameUtils.getName((String)resourceName);
    }

    private String getParentId(URI parentURI, ProcessingContext parentContext) {
        return (String)parentContext.context(CommonContext.ID, () -> this.generateId(parentURI, parentContext));
    }

    private String generateId(URI uri, ProcessingContext ctx) {
        return DigestUtils.md5Hex((String)uri.normalize().toString()).toLowerCase();
    }
}

