/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.Batch;
import com.github.euler.common.BatchListener;
import com.github.euler.common.CommonContext;
import com.github.euler.common.FragmentHandler;
import com.github.euler.common.FragmentParserContentHandler;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.Flush;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.FragmentBatchSink;
import com.github.euler.tika.FragmentBatchState;
import com.github.euler.tika.SinkItemResponse;
import com.github.euler.tika.SinkResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FragmentBatch
implements Batch {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Parser parser;
    private final StreamFactory sf;
    private final int fragmentSize;
    private final int fragmentOverlap;
    private final FragmentBatchSink sink;
    private FragmentBatchState state;

    public FragmentBatch(Parser parser, StreamFactory sf, int fragmentSize, int fragmentOverlap, FragmentBatchSink sink) {
        this.parser = parser;
        this.sf = sf;
        this.fragmentSize = fragmentSize;
        this.fragmentOverlap = fragmentOverlap;
        this.sink = sink;
        this.state = new FragmentBatchState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JobTaskToProcess msg, BatchListener listener) {
        SinkResponse response = this.sink.store(msg.itemURI, msg.ctx);
        String id = response.getId();
        this.state.itemStored(id, msg);
        boolean parseError = (Boolean)msg.ctx.context(CommonContext.PARSE_ERROR, (Object)false);
        URI uri = (URI)msg.ctx.context(CommonContext.PARSED_CONTENT_FILE, (Object)msg.itemURI);
        boolean isEmpty = this.sf.isEmpty(uri, msg.ctx);
        boolean isDirectory = (Boolean)msg.ctx.metadata("is_directory", (Object)false);
        if (isEmpty || isDirectory || parseError) {
            this.state.itemParsed(id);
        } else {
            BatchFragmentListener fragmentListener = new BatchFragmentListener(id, listener);
            try {
                this.parse(uri, msg.ctx, fragmentListener);
            }
            catch (IOException | TikaException | SAXException e) {
                this.LOGGER.warn("Error parsing {} for {}.", (Object)uri, (Object)e.getMessage());
            }
            finally {
                this.state.itemParsed(id);
            }
        }
        this.handleResponse(response, listener);
    }

    public void flush(Flush msg, BatchListener listener) {
        SinkResponse response = this.sink.flush(msg.force);
        this.handleResponse(response, listener);
    }

    public void handleResponse(SinkResponse response, BatchListener listener) {
        for (SinkItemResponse itemResponse : response.getResponses()) {
            String id;
            boolean finished;
            if (itemResponse.isFailed()) {
                Exception e = itemResponse.getFailureCause();
                this.LOGGER.warn("Sink operation failed.", (Throwable)e);
            }
            if (!(finished = this.state.itemIndexed(id = itemResponse.getId()))) continue;
            String parentId = this.state.getParent(id);
            JobTaskToProcess msg = this.state.getMessage(parentId);
            listener.finished(msg.itemURI, ProcessingContext.EMPTY);
            this.state.finish(parentId);
        }
    }

    protected void parse(URI uri, ProcessingContext ctx, FragmentHandler fragmentHandler) throws IOException, SAXException, TikaException {
        BodyContentHandler handler = new BodyContentHandler((ContentHandler)new FragmentParserContentHandler(this.fragmentSize, this.fragmentOverlap, fragmentHandler));
        try (InputStream in = this.sf.openInputStream(uri, ctx);){
            this.parser.parse(in, (ContentHandler)handler, new Metadata(), new ParseContext());
        }
    }

    public void finish() {
        this.sink.finish();
    }

    private class BatchFragmentListener
    implements FragmentHandler {
        final String id;
        int count = 0;
        final BatchListener listener;

        public BatchFragmentListener(String id, BatchListener listener) {
            this.id = id;
            this.listener = listener;
        }

        public void handleFragment(String frag) {
            SinkResponse response = FragmentBatch.this.sink.storeFragment(this.id, this.count++, frag);
            String fragId = response.getId();
            FragmentBatch.this.state.fragmentStored(this.id, fragId);
            FragmentBatch.this.handleResponse(response, this.listener);
        }
    }
}

