/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.metadata;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.metadata.MetadataOperation;
import com.github.euler.tika.metadata.MetadataParser;
import java.util.List;
import org.apache.tika.metadata.Metadata;

public class OperationsMetadataParser
implements MetadataParser {
    private final MetadataParser wrapped;
    private List<MetadataOperation> operations;

    public OperationsMetadataParser(MetadataParser wrapped, List<MetadataOperation> operations) {
        this.wrapped = wrapped;
        this.operations = operations;
    }

    @Override
    public ProcessingContext parse(Metadata metadata) {
        ProcessingContext ctx = this.wrapped.parse(metadata);
        ProcessingContext.Builder builder = ProcessingContext.builder();
        ctx.metadata().forEach((n, v) -> {
            for (MetadataOperation op : this.operations) {
                n = op.runOnName((String)n);
                v = op.runOnValue((String)n, v);
            }
            builder.metadata(n, v);
        });
        return builder.build();
    }
}

