/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.metadata;

import com.github.euler.tika.metadata.MetadataOperation;
import java.util.regex.Pattern;

public abstract class AbstractValueConverterMetadataOperation<T>
implements MetadataOperation {
    private final Pattern namePattern;
    private final boolean failSafe;

    public AbstractValueConverterMetadataOperation(String nameRegex, boolean failSafe) {
        this.namePattern = Pattern.compile(nameRegex);
        this.failSafe = failSafe;
    }

    @Override
    public Object runOnValue(String name, Object value) {
        if (this.namePattern.matcher(name).matches()) {
            try {
                return this.convert(value.toString());
            }
            catch (Exception e) {
                if (this.failSafe) {
                    return this.getDefaultValueOnError();
                }
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    protected abstract T getDefaultValueOnError();

    protected abstract T convert(String var1);
}

