/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.CommonContext;
import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.Item;
import com.github.euler.core.ItemProcessor;
import com.github.euler.core.ProcessingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class StripHTMLItemProcessor
implements ItemProcessor {
    private final StreamFactory sf;
    private final StorageStrategy parsedContentStrategy;

    public StripHTMLItemProcessor(StreamFactory sf, StorageStrategy parsedContentStrategy) {
        this.sf = sf;
        this.parsedContentStrategy = parsedContentStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingContext process(Item item) throws IOException {
        ProcessingContext ctx = item.ctx;
        URI uri = (URI)ctx.context(CommonContext.PARSED_CONTENT_FILE, null);
        boolean isEmpty = uri == null || this.sf.isEmpty(uri, ctx);
        boolean isDirectory = (Boolean)ctx.metadata("is_directory", (Object)false);
        if (!isDirectory && !isEmpty) {
            URI parsedContent = this.parsedContentStrategy.createFile(uri, ".txt");
            InputStream in = null;
            Writer out = null;
            try {
                in = this.sf.openInputStream(uri, ctx);
                out = new OutputStreamWriter(this.sf.openOutputStream(parsedContent, ctx), "utf-8");
                Document doc = Jsoup.parse((InputStream)in, (String)"utf-8", (String)uri.toURL().toString());
                out.write(doc.text());
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            return ProcessingContext.builder().context(CommonContext.PARSED_CONTENT_FILE, (Object)parsedContent).setAction(ProcessingContext.Action.OVERWRITE).build();
        }
        return ProcessingContext.EMPTY;
    }
}

