/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.ParseContextFactory;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;

public class DefaultParseContextFactory
implements ParseContextFactory {
    private final boolean skipOcr;
    private final List<Pattern> includeMimetypePatterns;
    private final List<Pattern> excludeMimetypePatterns;
    private final TesseractOCRConfig ocrConfig;

    public DefaultParseContextFactory(boolean skipOcr, List<String> includeMimetypeRegex, List<String> excludeMimetypeRegex, TesseractOCRConfig ocrConfig) {
        this.skipOcr = skipOcr;
        this.includeMimetypePatterns = this.compile(includeMimetypeRegex);
        this.excludeMimetypePatterns = this.compile(excludeMimetypeRegex);
        this.ocrConfig = ocrConfig;
    }

    private List<Pattern> compile(List<String> regex) {
        return regex.stream().map(r -> Pattern.compile(r)).collect(Collectors.toList());
    }

    public DefaultParseContextFactory() {
        this(true, List.of("a^"), List.of("^a"), new TesseractOCRConfig());
    }

    @Override
    public ParseContext create(ProcessingContext ctx) {
        String mimeType;
        ParseContext parseContext = new ParseContext();
        if (!this.skipOcr && (mimeType = (String)ctx.metadata("mime_type", null)) != null && this.matches(mimeType, this.includeMimetypePatterns) && !this.matches(mimeType, this.excludeMimetypePatterns)) {
            PDFParserConfig pdfConfig = new PDFParserConfig();
            pdfConfig.setExtractInlineImages(true);
            parseContext.set(PDFParserConfig.class, (Object)pdfConfig);
            parseContext.set(TesseractOCRConfig.class, (Object)this.ocrConfig);
        }
        return parseContext;
    }

    private boolean matches(String value, List<Pattern> patterns) {
        return patterns.stream().anyMatch(p -> p.matcher(value).matches());
    }
}

