/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.metadata;

import com.github.euler.tika.metadata.MetadataOperation;
import java.util.Arrays;
import java.util.regex.Pattern;

public class ValueReplaceMetadataOperation
implements MetadataOperation {
    private final Pattern patternName;
    private final Pattern pattern;
    private final String replacement;

    public ValueReplaceMetadataOperation(String nameRegex, String regex, String replacement) {
        this.patternName = Pattern.compile(nameRegex);
        this.pattern = Pattern.compile(regex);
        this.replacement = replacement;
    }

    @Override
    public Object runOnValue(String name, Object value) {
        if (this.patternName.matcher(name).matches()) {
            if (value instanceof String) {
                return this.pattern.matcher(value.toString()).replaceAll(this.replacement);
            }
            if (value instanceof String[]) {
                String[] arr = (String[])value;
                return Arrays.stream(arr).map(v -> this.pattern.matcher((CharSequence)v).replaceAll(this.replacement)).toArray(String[]::new);
            }
            return value;
        }
        return value;
    }
}

