/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.github.euler.common.CommonContext;
import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.EmbeddedItemFound;
import com.github.euler.core.JobTaskFinished;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.TaskCommand;
import com.github.euler.tika.EmbeddedItemListener;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.EmbeddedStrategy;
import com.github.euler.tika.EmbeddedStrategyFactory;
import com.github.euler.tika.ParseContextFactory;
import com.github.euler.tika.ParseContextFactoryWrapper;
import com.github.euler.tika.metadata.MetadataParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParseExecution
extends AbstractBehavior<TaskCommand>
implements EmbeddedItemListener {
    private final Parser parser;
    private final StreamFactory sf;
    private final StorageStrategy parsedContentStrategy;
    private final StorageStrategy embeddedContentStrategy;
    private final MetadataParser metadataParser;
    private final ParseContextFactory parseContextFactory;
    private final EmbeddedNamingStrategy embeddedNamingStrategy;
    private final EmbeddedStrategyFactory embeddedStrategyFactory;
    private JobTaskToProcess currentMsg;

    public static Behavior<TaskCommand> create(Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, MetadataParser metadataParser, ParseContextFactory parseContextFactory, EmbeddedNamingStrategy embeddedNamingStrategy, EmbeddedStrategyFactory embeddedStrategyFactory) {
        return Behaviors.setup((Function & Serializable)context -> new ParseExecution((ActorContext<TaskCommand>)context, parser, sf, parsedContentStrategy, embeddedContentStrategy, metadataParser, parseContextFactory, embeddedNamingStrategy, embeddedStrategyFactory));
    }

    protected ParseExecution(ActorContext<TaskCommand> context, Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, MetadataParser metadataParser, ParseContextFactory parseContextFactory, EmbeddedNamingStrategy embeddedNamingStrategy, EmbeddedStrategyFactory embeddedStrategyFactory) {
        super(context);
        this.parser = parser;
        this.sf = sf;
        this.parsedContentStrategy = parsedContentStrategy;
        this.embeddedContentStrategy = embeddedContentStrategy;
        this.metadataParser = metadataParser;
        this.parseContextFactory = parseContextFactory;
        this.embeddedNamingStrategy = embeddedNamingStrategy;
        this.embeddedStrategyFactory = embeddedStrategyFactory;
    }

    public Receive<TaskCommand> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        builder.onMessage(JobTaskToProcess.class, this::onJobTaskToProcess);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Behavior<TaskCommand> onJobTaskToProcess(JobTaskToProcess msg) throws IOException, SAXException, TikaException {
        this.currentMsg = msg;
        ProcessingContext.Builder builder = ProcessingContext.builder();
        URI parsedContent = this.createParsedContent(msg.itemURI);
        builder.context(CommonContext.PARSED_CONTENT_FILE, (Object)parsedContent);
        if (msg.ctx.context(CommonContext.ID) != null) {
            builder.metadata("parents", msg.ctx.metadata("parents", List.of()));
        }
        InputStream in = null;
        Writer out = null;
        try {
            in = this.sf.openInputStream(msg.itemURI, msg.ctx);
            out = new OutputStreamWriter(this.sf.openOutputStream(parsedContent, msg.ctx), "utf-8");
            ProcessingContext parsed = this.parse(in, out, msg.ctx);
            ProcessingContext ctx = msg.ctx.merge(builder.build()).merge(parsed);
            msg.replyTo.tell((Object)new JobTaskFinished(msg, ctx));
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return this;
    }

    protected ProcessingContext parse(InputStream in, Writer out, ProcessingContext ctx) throws IOException, SAXException, TikaException {
        try {
            Metadata metadata = new Metadata();
            EmbeddedStrategy embeddedStrategy = this.embeddedStrategyFactory.newEmbeddedStrategy(this);
            ParseContextFactoryWrapper wrapper = new ParseContextFactoryWrapper(this.parser, this.parseContextFactory, embeddedStrategy);
            ParseContext parseContext = wrapper.create(ctx);
            this.parser.parse(in, (ContentHandler)new BodyContentHandler(out), metadata, parseContext);
            return this.metadataParser.parse(metadata);
        }
        catch (EncryptedDocumentException e) {
            return ProcessingContext.builder().metadata("encrypted", (Object)true).build();
        }
    }

    private URI createParsedContent(URI itemURI) throws IOException {
        return this.parsedContentStrategy.createFile(itemURI);
    }

    @Override
    public void newEmbedded(InputStream in, Metadata metadata) {
        String name = this.embeddedNamingStrategy.nameEmbedded(this.currentMsg.itemURI, this.currentMsg.ctx, metadata);
        URI embeddedFile = this.embeddedContentStrategy.createFileWithName(name);
        try (OutputStream out = this.sf.openOutputStream(embeddedFile, ProcessingContext.EMPTY);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ProcessingContext.Builder builder = ProcessingContext.builder().metadata("created_datetime", (Object)metadata.getDate(TikaCoreProperties.CREATED)).metadata("last_modified_datetime", (Object)metadata.getDate(TikaCoreProperties.MODIFIED)).metadata("name", (Object)name).context(CommonContext.TEMPORARY_URI, (Object)embeddedFile).setAction(ProcessingContext.Action.OVERWRITE);
        this.setPathAttribute(builder, name, "relative_path", "path");
        Integer depth = (Integer)this.currentMsg.ctx.context(CommonContext.EXTRACTION_DEPTH, (Object)0);
        builder.context(CommonContext.EXTRACTION_DEPTH, (Object)(depth + 1));
        String parentId = (String)this.currentMsg.ctx.context(CommonContext.ID);
        if (parentId != null) {
            ArrayList<String> parents = new ArrayList<String>((Collection)this.currentMsg.ctx.metadata("parents", List.of()));
            parents.add(parentId);
            builder.metadata("parents", Collections.unmodifiableList(parents));
        }
        ProcessingContext ctx = builder.build();
        this.currentMsg.replyTo.tell((Object)new EmbeddedItemFound(embeddedFile, this.currentMsg, ctx));
    }

    private void setPathAttribute(ProcessingContext.Builder builder, String name, String ... attrNames) {
        Map currMetadata = this.currentMsg.ctx.metadata();
        for (String attrName : attrNames) {
            if (!currMetadata.containsKey(attrName)) continue;
            String path = currMetadata.get(attrName) + "#" + name;
            builder.metadata(attrName, (Object)path);
        }
    }
}

