/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.embedded;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.embedded.DefaultEmbeddedNamingStrategy;
import java.net.URI;
import java.util.Map;
import org.apache.tika.metadata.Metadata;

public class MimetypeEmbeddedNamingStrategy
implements EmbeddedNamingStrategy {
    private final EmbeddedNamingStrategy defaultStrategy;
    private final Map<String, EmbeddedNamingStrategy> mapping;

    public MimetypeEmbeddedNamingStrategy(EmbeddedNamingStrategy defaultStrategy, Map<String, EmbeddedNamingStrategy> mapping) {
        this.defaultStrategy = defaultStrategy;
        this.mapping = mapping;
    }

    public MimetypeEmbeddedNamingStrategy(Map<String, EmbeddedNamingStrategy> mapping) {
        this(new DefaultEmbeddedNamingStrategy(), mapping);
    }

    @Override
    public String nameEmbedded(URI parentURI, ProcessingContext parentContext, Metadata embeddedMetadata) {
        String mimetype = embeddedMetadata.get("Content-Type");
        EmbeddedNamingStrategy strategy = this.mapping.getOrDefault(mimetype, this.defaultStrategy);
        return strategy.nameEmbedded(parentURI, parentContext, embeddedMetadata);
    }
}

