/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import akka.actor.typed.Behavior;
import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.Task;
import com.github.euler.core.TaskCommand;
import com.github.euler.tika.DefaultEmbeddedStrategy;
import com.github.euler.tika.DefaultParseContextFactory;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.euler.tika.EmbeddedStrategy;
import com.github.euler.tika.ParseContextFactory;
import com.github.euler.tika.ParseExecution;
import com.github.euler.tika.embedded.DefaultEmbeddedNamingStrategy;
import com.github.euler.tika.metadata.DefaultMetadataParser;
import com.github.euler.tika.metadata.MetadataParser;
import java.util.Objects;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;

public class ParseTask
implements Task {
    private final String name;
    private final Parser parser;
    private final StreamFactory sf;
    private final StorageStrategy parsedContentStrategy;
    private final StorageStrategy embeddedContentStrategy;
    private final MetadataParser metadataParser;
    private final ParseContextFactory parseContextFactory;
    private final EmbeddedNamingStrategy embeddedNamingStrategy;
    private final EmbeddedStrategy embeddedStrategy;

    private ParseTask(String name, Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, MetadataParser metadataParser, ParseContextFactory parseContextFactory, EmbeddedNamingStrategy embeddedNamingStrategy, EmbeddedStrategy embeddedStrategy) {
        this.name = name;
        this.parser = parser;
        this.sf = sf;
        this.parsedContentStrategy = parsedContentStrategy;
        this.embeddedContentStrategy = embeddedContentStrategy;
        this.metadataParser = metadataParser;
        this.parseContextFactory = parseContextFactory;
        this.embeddedNamingStrategy = embeddedNamingStrategy;
        this.embeddedStrategy = embeddedStrategy;
    }

    public String name() {
        return this.name;
    }

    public Behavior<TaskCommand> behavior() {
        return ParseExecution.create(this.parser, this.sf, this.parsedContentStrategy, this.embeddedContentStrategy, this.metadataParser, this.parseContextFactory, this.embeddedNamingStrategy, this.embeddedStrategy);
    }

    public boolean accept(JobTaskToProcess msg) {
        boolean isEmpty = this.sf.isEmpty(msg.itemURI, msg.ctx);
        boolean exists = this.sf.exists(msg.itemURI, msg.ctx);
        boolean isDirectory = (Boolean)msg.ctx.metadata("is_directory", (Object)false);
        return exists && !isEmpty && !isDirectory;
    }

    public static Builder builder(String name, StreamFactory streamFactory, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy) {
        return new Builder(name, streamFactory, parsedContentStrategy, embeddedContentStrategy);
    }

    public static class Builder {
        private String name;
        private Parser parser = new AutoDetectParser();
        private StreamFactory streamFactory;
        private StorageStrategy parsedContentStrategy;
        private StorageStrategy embeddedContentStrategy;
        private MetadataParser metadataParser = new DefaultMetadataParser();
        private ParseContextFactory parseContextFactory = new DefaultParseContextFactory();
        private EmbeddedNamingStrategy embeddedNamingStrategy = new DefaultEmbeddedNamingStrategy();
        private EmbeddedStrategy embeddedStrategy = DefaultEmbeddedStrategy.builder().build();

        private Builder(String name, StreamFactory streamFactory, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy) {
            this.name = name;
            this.streamFactory = streamFactory;
            this.parsedContentStrategy = parsedContentStrategy;
            this.embeddedContentStrategy = embeddedContentStrategy;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Parser getParser() {
            return this.parser;
        }

        public Builder setParser(AutoDetectParser parser) {
            this.parser = parser;
            return this;
        }

        public StreamFactory getStreamFactory() {
            return this.streamFactory;
        }

        public Builder setStreamFactory(StreamFactory streamFactory) {
            this.streamFactory = streamFactory;
            return this;
        }

        public ParseContextFactory getParseContextFactory() {
            return this.parseContextFactory;
        }

        public Builder setParseContextFactory(ParseContextFactory parseContextFactory) {
            this.parseContextFactory = parseContextFactory;
            return this;
        }

        public Builder setEmbeddedContentStrategy(StorageStrategy embeddedContentStrategy) {
            this.embeddedContentStrategy = embeddedContentStrategy;
            return this;
        }

        public StorageStrategy getEmbeddedContentStrategy() {
            return this.embeddedContentStrategy;
        }

        public MetadataParser getMetadataParser() {
            return this.metadataParser;
        }

        public Builder setMetadataParser(MetadataParser metadataParser) {
            this.metadataParser = metadataParser;
            return this;
        }

        public StorageStrategy getParsedContentStrategy() {
            return this.parsedContentStrategy;
        }

        public Builder setParsedContentStrategy(StorageStrategy parsedContentStrategy) {
            this.parsedContentStrategy = parsedContentStrategy;
            return this;
        }

        public EmbeddedNamingStrategy getEmbeddedNamingStrategy() {
            return this.embeddedNamingStrategy;
        }

        public Builder setEmbeddedNamingStrategy(EmbeddedNamingStrategy embeddedNamingStrategy) {
            this.embeddedNamingStrategy = embeddedNamingStrategy;
            return this;
        }

        public EmbeddedStrategy getEmbeddedStrategy() {
            return this.embeddedStrategy;
        }

        public Builder setEmbeddedStrategy(EmbeddedStrategy embeddedStrategy) {
            this.embeddedStrategy = embeddedStrategy;
            return this;
        }

        public ParseTask build() {
            Objects.requireNonNull(this.name, () -> "name cannot be null");
            Objects.requireNonNull(this.parser, () -> "parser cannot be null");
            Objects.requireNonNull(this.streamFactory, () -> "streamFactory cannot be null");
            Objects.requireNonNull(this.parsedContentStrategy, () -> "parsedContentStrategy cannot be null");
            Objects.requireNonNull(this.metadataParser, () -> "metadataParser cannot be null");
            Objects.requireNonNull(this.parseContextFactory, () -> "parseContextFactory cannot be null");
            Objects.requireNonNull(this.embeddedNamingStrategy, () -> "embeddedNamingStrategy cannot be null");
            Objects.requireNonNull(this.embeddedStrategy, () -> "embeddedStrategy cannot be null");
            return new ParseTask(this.name, this.parser, this.streamFactory, this.parsedContentStrategy, this.embeddedContentStrategy, this.metadataParser, this.parseContextFactory, this.embeddedNamingStrategy, this.embeddedStrategy);
        }
    }
}

