/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.StreamFactory;
import com.github.euler.configuration.AbstractTaskConfigConverter;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TasksConfigConverter;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.Task;
import com.github.euler.tika.MimeTypeDetectTask;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;
import org.apache.tika.detect.Detector;

public class MimeTypeDetectTaskConfigConverter
extends AbstractTaskConfigConverter {
    public String type() {
        return "mime-type-detect";
    }

    public Task convert(Config config, ConfigContext ctx, TypesConfigConverter typeConfigConverter, TasksConfigConverter tasksConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        String name = this.getName(config, tasksConfigConverter);
        String field = config.getString("field");
        Detector detector = (Detector)ctx.getRequired(Detector.class);
        StreamFactory sf = (StreamFactory)ctx.getRequired(StreamFactory.class);
        return new MimeTypeDetectTask(name, field, sf, detector);
    }

    protected Config getDefaultConfig() {
        URL resource = MimeTypeDetectTaskConfigConverter.class.getClassLoader().getResource("mimetypetask.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

