/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.tika.AbstractEmbeddedStrategeyConfigConverter;
import com.github.euler.tika.DefaultEmbeddedStrategy;
import com.github.euler.tika.EmbeddedStrategy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.net.URL;
import java.util.List;

public class DefaultEmbeddedStrategyConfigConverter
extends AbstractEmbeddedStrategeyConfigConverter {
    public String configType() {
        return "default";
    }

    public EmbeddedStrategy convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = this.getConfig(config);
        int maxDepth = config.getInt("max-depth");
        List<String> includeParseEmbeddedRegex = this.getListOrString("parse.include-regex", config);
        List<String> excludeParseEmbeddedRegex = this.getListOrString("parse.exclude-regex", config);
        List<String> includeExtractEmbeddedRegex = this.getListOrString("extract.include-regex", config);
        List<String> excludeExtractEmbeddedRegex = this.getListOrString("extract.exclude-regex", config);
        String mimeTypeField = config.getString("mime-type-field");
        boolean outputName = config.getBoolean("output-name");
        return new DefaultEmbeddedStrategy(maxDepth, includeParseEmbeddedRegex, excludeParseEmbeddedRegex, includeExtractEmbeddedRegex, excludeExtractEmbeddedRegex, mimeTypeField, outputName);
    }

    protected Config getConfig(Config config) {
        return ConfigFactory.parseString((String)config.root().render(ConfigRenderOptions.concise())).withFallback((ConfigMergeable)this.getDefaultConfig()).resolve();
    }

    private List<String> getListOrString(String path, Config config) {
        try {
            return List.of(config.getString(path));
        }
        catch (ConfigException.WrongType e) {
            return config.getStringList(path);
        }
    }

    protected Config getDefaultConfig() {
        URL resource = DefaultEmbeddedStrategyConfigConverter.class.getClassLoader().getResource("defaultembeddedstrategy.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

