/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.metadata;

import com.github.euler.tika.metadata.MetadataOperation;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ValueRegexExtractMetadataOperation
implements MetadataOperation {
    private final Pattern patternName;
    private final Pattern pattern;

    public ValueRegexExtractMetadataOperation(String nameRegex, String regex) {
        this.patternName = Pattern.compile(nameRegex);
        this.pattern = Pattern.compile(regex);
    }

    public ValueRegexExtractMetadataOperation(String regex) {
        this(".+", regex);
    }

    @Override
    public Object runOnValue(String name, Object value) {
        if (this.patternName.matcher(name).matches()) {
            if (value instanceof String) {
                return this.extract(value.toString()).toArray(String[]::new);
            }
            if (value instanceof String[]) {
                String[] arr = (String[])value;
                return Arrays.stream(arr).map(v -> this.extract((String)v)).flatMap(s -> s.stream()).collect(Collectors.toSet()).toArray(String[]::new);
            }
            return value;
        }
        return value;
    }

    public Set<String> extract(String value) {
        TreeSet<String> found = new TreeSet<String>();
        String fieldValue = value.toString();
        Matcher matcher = this.pattern.matcher(fieldValue);
        while (matcher.find()) {
            found.add(matcher.group(0));
        }
        return found;
    }
}

