/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.CommonContext;
import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DefaultEmbeddedStrategy
extends EmbeddedStrategy {
    private static final Parser DELEGATING_PARSER = new DelegatingParser();
    private static final String LINE_BREAK = "\n";
    private final int maxDepth;
    private final List<Pattern> includeParseEmbeddedPatterns;
    private final List<Pattern> excludeParseEmbeddedPatterns;
    private final List<Pattern> includeExtractEmbeddedPatterns;
    private final List<Pattern> excludeExtractEmbeddedPatterns;
    private final String mimeTypeField;
    private final boolean outputName;

    public DefaultEmbeddedStrategy(int maxDepth, List<String> includeParseEmbeddedRegex, List<String> excludeParseEmbeddedRegex, List<String> includeExtractEmbeddedRegex, List<String> excludeExtractEmbeddedRegex, String mimeTypeField, boolean outputName) {
        this.maxDepth = maxDepth;
        this.includeParseEmbeddedPatterns = this.toPattern(includeParseEmbeddedRegex);
        this.excludeParseEmbeddedPatterns = this.toPattern(excludeParseEmbeddedRegex);
        this.includeExtractEmbeddedPatterns = this.toPattern(includeExtractEmbeddedRegex);
        this.excludeExtractEmbeddedPatterns = this.toPattern(excludeExtractEmbeddedRegex);
        this.mimeTypeField = mimeTypeField;
        this.outputName = outputName;
    }

    private List<Pattern> toPattern(List<String> regex) {
        return Collections.unmodifiableList(regex.stream().map(r -> Pattern.compile(r)).collect(Collectors.toList()));
    }

    public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        String resourceName = metadata.get("resourceName");
        if (this.outputName && resourceName != null) {
            handler.characters(resourceName.toCharArray(), 0, resourceName.length());
            if (outputHtml) {
                handler.startElement("http://www.w3.org/1999/xhtml", "br", "br", new AttributesImpl());
                handler.endElement("http://www.w3.org/1999/xhtml", "br", "br");
            } else {
                handler.characters(LINE_BREAK.toCharArray(), 0, LINE_BREAK.length());
            }
        }
        if (this.shouldExtractEmbedded(metadata)) {
            this.notifyNewExtractedEmbedded(stream, metadata);
        } else {
            try {
                DELEGATING_PARSER.parse(stream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler(handler)), metadata, this.getParseContext());
            }
            catch (TikaException e) {
                throw new IOException(e);
            }
        }
    }

    protected boolean shouldExtractEmbedded(Metadata metadata) {
        String mimeType = metadata.get("Content-Type");
        if (mimeType == null) {
            mimeType = "application/unknown";
        }
        return this.isIncluded(this.includeExtractEmbeddedPatterns, this.excludeExtractEmbeddedPatterns, mimeType);
    }

    @Override
    protected boolean shouldParseEmbedded(ProcessingContext ctx) {
        String mimeType = (String)ctx.metadata(this.mimeTypeField, null);
        boolean included = this.isIncluded(this.includeParseEmbeddedPatterns, this.excludeParseEmbeddedPatterns, mimeType);
        return included && !this.isAboveMaxDepth(ctx);
    }

    private boolean isAboveMaxDepth(ProcessingContext processingContext) {
        int depth = (Integer)processingContext.context(CommonContext.EXTRACTION_DEPTH, (Object)0);
        return depth > this.maxDepth;
    }

    protected boolean isIncluded(List<Pattern> includedPatterns, List<Pattern> excludedPatterns, String value) {
        if (value != null) {
            boolean included = this.anyMatches(includedPatterns, value);
            boolean excluded = this.anyMatches(excludedPatterns, value);
            return included && !excluded;
        }
        return false;
    }

    private boolean anyMatches(List<Pattern> patterns, String value) {
        return patterns.stream().anyMatch(p -> p.matcher(value).matches());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public List<Pattern> getIncludeParseEmbeddedPatterns() {
        return this.includeParseEmbeddedPatterns;
    }

    public List<Pattern> getExcludeParseEmbeddedPatterns() {
        return this.excludeParseEmbeddedPatterns;
    }

    public List<Pattern> getIncludeExtractEmbeddedPatterns() {
        return this.includeExtractEmbeddedPatterns;
    }

    public List<Pattern> getExcludeExtractEmbeddedPatterns() {
        return this.excludeExtractEmbeddedPatterns;
    }

    public String getMimeTypeField() {
        return this.mimeTypeField;
    }

    public boolean isOutputName() {
        return this.outputName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int maxDepth = 10;
        private List<String> includeParseEmbeddedRegex = List.of(".+");
        private List<String> excludeParseEmbeddedRegex = List.of("a^");
        private List<String> includeExtractEmbeddedRegex = List.of("a^");
        private List<String> excludeExtractEmbeddedRegex = List.of("a^");
        private String mimeTypeField = "mime_type";
        private boolean outputName = false;

        private Builder() {
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public Builder setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public List<String> getIncludeParseEmbeddedRegex() {
            return this.includeParseEmbeddedRegex;
        }

        public Builder setIncludeParseEmbeddedRegex(List<String> includeParseEmbeddedRegex) {
            this.includeParseEmbeddedRegex = includeParseEmbeddedRegex;
            return this;
        }

        public Builder setIncludeParseEmbeddedRegex(String includeParseEmbeddedRegex) {
            this.includeParseEmbeddedRegex = List.of(includeParseEmbeddedRegex);
            return this;
        }

        public List<String> getExcludeParseEmbeddedRegex() {
            return this.excludeParseEmbeddedRegex;
        }

        public Builder setExcludeParseEmbeddedRegex(List<String> excludeParseEmbeddedRegex) {
            this.excludeParseEmbeddedRegex = excludeParseEmbeddedRegex;
            return this;
        }

        public Builder setExcludeParseEmbeddedRegex(String excludeParseEmbeddedRegex) {
            this.excludeParseEmbeddedRegex = List.of(excludeParseEmbeddedRegex);
            return this;
        }

        public List<String> getIncludeExtractEmbeddedRegex() {
            return this.includeExtractEmbeddedRegex;
        }

        public Builder setIncludeExtractEmbeddedRegex(List<String> includeExtractEmbeddedRegex) {
            this.includeExtractEmbeddedRegex = includeExtractEmbeddedRegex;
            return this;
        }

        public Builder setIncludeExtractEmbeddedRegex(String includeExtractEmbeddedRegex) {
            this.includeExtractEmbeddedRegex = List.of(includeExtractEmbeddedRegex);
            return this;
        }

        public List<String> getExcludeExtractEmbeddedRegex() {
            return this.excludeExtractEmbeddedRegex;
        }

        public Builder setExcludeExtractEmbeddedRegex(List<String> excludeExtractEmbeddedRegex) {
            this.excludeExtractEmbeddedRegex = excludeExtractEmbeddedRegex;
            return this;
        }

        public Builder setExcludeExtractEmbeddedRegex(String excludeExtractEmbeddedRegex) {
            this.excludeExtractEmbeddedRegex = List.of(excludeExtractEmbeddedRegex);
            return this;
        }

        public String getMimeTypeField() {
            return this.mimeTypeField;
        }

        public Builder setMimeTypeField(String mimeTypeField) {
            this.mimeTypeField = mimeTypeField;
            return this;
        }

        public boolean isOutputName() {
            return this.outputName;
        }

        public Builder setOutputName(boolean outputName) {
            this.outputName = outputName;
            return this;
        }

        public DefaultEmbeddedStrategy build() {
            return new DefaultEmbeddedStrategy(this.maxDepth, this.includeParseEmbeddedRegex, this.excludeParseEmbeddedRegex, this.includeExtractEmbeddedRegex, this.excludeExtractEmbeddedRegex, this.mimeTypeField, this.outputName);
        }
    }
}

