/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.metadata;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.tika.metadata.AbstractMetadataParserConfigConverter;
import com.github.euler.tika.metadata.DefaultMetadataParser;
import com.github.euler.tika.metadata.MetadataFieldParser;
import com.github.euler.tika.metadata.MetadataParser;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultMetadataParserConfigConverter
extends AbstractMetadataParserConfigConverter {
    public String configType() {
        return "default";
    }

    public MetadataParser convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        String includePattern = config.getString("include-field-regex");
        String excludePattern = config.getString("exclude-field-regex");
        List<MetadataFieldParser> fieldParsers = config.getList("field-parsers").stream().map(c -> this.convertFieldParser(configContext, typeConfigConverter, (ConfigValue)c)).collect(Collectors.toList());
        return this.create(config, includePattern, excludePattern, fieldParsers);
    }

    protected MetadataParser create(Config config, String includePattern, String excludePattern, List<MetadataFieldParser> fieldParsers) {
        return new DefaultMetadataParser(includePattern, excludePattern, fieldParsers);
    }

    protected MetadataFieldParser convertFieldParser(ConfigContext configContext, TypesConfigConverter typeConfigConverter, ConfigValue c) {
        return (MetadataFieldParser)typeConfigConverter.convert("metadata-field-parser", c, configContext);
    }

    protected Config getDefaultConfig() {
        URL resource = DefaultMetadataParserConfigConverter.class.getClassLoader().getResource("defaultmetadataparser.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

