/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika.embedded;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedNamingStrategy;
import com.github.slugify.Slugify;
import java.net.URI;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;

public class RFC822EmbeddedNamingStrategy
implements EmbeddedNamingStrategy {
    private final Pattern identifierPattern;
    private final Slugify slg = new Slugify();

    public RFC822EmbeddedNamingStrategy(String identifierRegex) {
        this.identifierPattern = Pattern.compile(identifierRegex);
    }

    @Override
    public String nameEmbedded(URI parentURI, ProcessingContext parentContext, Metadata embeddedMetadata) {
        String subject = this.getSubject(embeddedMetadata);
        String identifier = this.getIdentifier(embeddedMetadata);
        String name = this.slg.slugify(identifier + "_" + subject);
        return name + ".eml";
    }

    protected String getSubject(Metadata embeddedMetadata) {
        String subject = embeddedMetadata.get("subject");
        if (subject.length() > 20) {
            subject = subject.substring(0, 20);
        }
        return subject;
    }

    protected String getIdentifier(Metadata embeddedMetadata) {
        Matcher matcher;
        String identifier = embeddedMetadata.get("identifier");
        identifier = identifier != null ? ((matcher = this.identifierPattern.matcher(identifier.trim())).find() ? matcher.group(1) : UUID.randomUUID().toString()) : UUID.randomUUID().toString();
        return identifier;
    }
}

