/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedStrategy;
import com.github.euler.tika.ParseContextFactory;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.parser.ParseContext;

public class ParseContextFactoryWrapper
implements ParseContextFactory {
    private final ParseContextFactory wrapped;
    private EmbeddedStrategy embeddedStrategy;

    public ParseContextFactoryWrapper(ParseContextFactory wrapped, EmbeddedStrategy embeddedStrategy) {
        this.wrapped = wrapped;
        this.embeddedStrategy = embeddedStrategy;
    }

    @Override
    public ParseContext create(ProcessingContext processingContext) {
        ParseContext ctx = this.wrapped.create(processingContext);
        if (this.embeddedStrategy.shouldParseEmbedded(processingContext)) {
            this.embeddedStrategy.setParseContext(ctx);
            ctx.set(EmbeddedDocumentExtractor.class, (Object)this.embeddedStrategy);
        }
        return ctx;
    }
}

