/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.tika.AbstractParseContextFactory;
import com.github.euler.tika.DefaultParseContextFactory;
import com.github.euler.tika.ParseContextFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;
import java.util.List;
import org.apache.tika.parser.ocr.TesseractOCRConfig;

public class DefaultParseContextFactoryConfigConverter
extends AbstractParseContextFactory {
    public String configType() {
        return "default";
    }

    public ParseContextFactory convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        boolean skipOcr = config.getBoolean("ocr.skip-ocr");
        List<String> includeMimetypeRegex = this.getList(config, "ocr.include-mime-type-regex");
        List<String> excludeMimetypeRegex = this.getList(config, "ocr.exclude-mime-type-regex");
        TesseractOCRConfig ocrConfig = new TesseractOCRConfig();
        ocrConfig.setLanguage(config.getString("ocr.language"));
        ocrConfig.setEnableImageProcessing(config.getBoolean("ocr.enable-image-processing") ? 1 : 0);
        ocrConfig.setFilter(config.getString("ocr.filter"));
        ocrConfig.setMinFileSizeToOcr(config.getLong("ocr.min-file-size-to-ocr"));
        ocrConfig.setMaxFileSizeToOcr(config.getLong("ocr.max-file-size-to-ocr"));
        return new DefaultParseContextFactory(skipOcr, includeMimetypeRegex, excludeMimetypeRegex, ocrConfig);
    }

    private List<String> getList(Config config, String path) {
        try {
            return config.getStringList(path);
        }
        catch (ConfigException.WrongType e) {
            return List.of(config.getString(path));
        }
    }

    protected Config getDefaultConfig() {
        URL resource = DefaultParseContextFactoryConfigConverter.class.getClassLoader().getResource("defaultparsecontext.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

