/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.configuration.AbstractTaskConfigConverter;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TasksConfigConverter;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.Task;
import com.github.euler.tika.ParseTask;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;

public class ParseTaskConfigConverter
extends AbstractTaskConfigConverter {
    public String type() {
        return "parse";
    }

    public Task convert(Config config, ConfigContext ctx, TypesConfigConverter typeConfigConverter, TasksConfigConverter tasksConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        String name = this.getName(config, tasksConfigConverter);
        StreamFactory streamFactory = (StreamFactory)ctx.getRequired(StreamFactory.class);
        StorageStrategy parsedContentStrategy = (StorageStrategy)typeConfigConverter.convert("storage-strategy", config.getValue("parsed-storage-strategy"), ctx);
        StorageStrategy embeddedContentStrategy = (StorageStrategy)typeConfigConverter.convert("storage-strategy", config.getValue("embedded-storage-strategy"), ctx);
        return ParseTask.builder(name, streamFactory, parsedContentStrategy, embeddedContentStrategy).build();
    }

    protected Config getDefaultConfig() {
        URL resource = ParseTaskConfigConverter.class.getClassLoader().getResource("parsetask.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

