/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import akka.actor.typed.Behavior;
import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.Task;
import com.github.euler.core.TaskCommand;
import com.github.euler.tika.DefaultMetadataParser;
import com.github.euler.tika.FixedParseContextFactory;
import com.github.euler.tika.MetadataParser;
import com.github.euler.tika.ParseContextFactory;
import com.github.euler.tika.ParseExecution;
import java.util.Objects;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;

public class ParseTask
implements Task {
    private final String name;
    private final Parser parser;
    private final StreamFactory sf;
    private final StorageStrategy parsedContentStrategy;
    private final StorageStrategy embeddedContentStrategy;
    private boolean extractEmbedded;
    private final String includeExtractEmbeddedPattern;
    private final String excludeExtractEmbeddedPattern;
    private final MetadataParser metadataParser;
    private final ParseContextFactory parseContextFactory;

    private ParseTask(String name, Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, boolean extractEmbedded, String includeExtractEmbeddedPattern, String excludeExtractEmbeddedPattern, MetadataParser metadataParser, ParseContextFactory parseContextFactory) {
        this.name = name;
        this.parser = parser;
        this.sf = sf;
        this.parsedContentStrategy = parsedContentStrategy;
        this.embeddedContentStrategy = embeddedContentStrategy;
        this.extractEmbedded = extractEmbedded;
        this.includeExtractEmbeddedPattern = includeExtractEmbeddedPattern;
        this.excludeExtractEmbeddedPattern = excludeExtractEmbeddedPattern;
        this.metadataParser = metadataParser;
        this.parseContextFactory = parseContextFactory;
    }

    public String name() {
        return this.name;
    }

    public Behavior<TaskCommand> behavior() {
        return ParseExecution.create(this.parser, this.sf, this.parsedContentStrategy, this.embeddedContentStrategy, this.extractEmbedded, this.includeExtractEmbeddedPattern, this.excludeExtractEmbeddedPattern, this.metadataParser, this.parseContextFactory);
    }

    public boolean accept(JobTaskToProcess msg) {
        return this.sf.exists(msg.itemURI) && !this.sf.isEmpty(msg.itemURI);
    }

    public static Builder builder(String name, StreamFactory streamFactory, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy) {
        return new Builder(name, streamFactory, parsedContentStrategy, embeddedContentStrategy);
    }

    public static class Builder {
        private String name;
        private Parser parser = new AutoDetectParser();
        private StreamFactory streamFactory;
        private StorageStrategy parsedContentStrategy;
        private StorageStrategy embeddedContentStrategy;
        private MetadataParser metadataParser = new DefaultMetadataParser();
        private ParseContextFactory parseContextFactory = new FixedParseContextFactory(new ParseContext());
        private boolean extractEmbedded = false;
        private String includeExtractEmbeddedPattern = ".+";
        private String excludeExtractEmbeddedPattern = "a^";

        private Builder(String name, StreamFactory streamFactory, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy) {
            this.name = name;
            this.streamFactory = streamFactory;
            this.parsedContentStrategy = parsedContentStrategy;
            this.embeddedContentStrategy = embeddedContentStrategy;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Parser getParser() {
            return this.parser;
        }

        public Builder setParser(AutoDetectParser parser) {
            this.parser = parser;
            return this;
        }

        public StreamFactory getStreamFactory() {
            return this.streamFactory;
        }

        public Builder setStreamFactory(StreamFactory streamFactory) {
            this.streamFactory = streamFactory;
            return this;
        }

        public ParseContextFactory getParseContextFactory() {
            return this.parseContextFactory;
        }

        public Builder setParseContextFactory(ParseContextFactory parseContextFactory) {
            this.parseContextFactory = parseContextFactory;
            return this;
        }

        public Builder setEmbeddedContentStrategy(StorageStrategy embeddedContentStrategy) {
            this.embeddedContentStrategy = embeddedContentStrategy;
            return this;
        }

        public StorageStrategy getEmbeddedContentStrategy() {
            return this.embeddedContentStrategy;
        }

        public MetadataParser getMetadataParser() {
            return this.metadataParser;
        }

        public Builder setMetadataParser(MetadataParser metadataParser) {
            this.metadataParser = metadataParser;
            return this;
        }

        public StorageStrategy getParsedContentStrategy() {
            return this.parsedContentStrategy;
        }

        public Builder setParsedContentStrategy(StorageStrategy parsedContentStrategy) {
            this.parsedContentStrategy = parsedContentStrategy;
            return this;
        }

        public Builder setExtractEmbedded(boolean extractEmbedded) {
            this.extractEmbedded = extractEmbedded;
            return this;
        }

        public Builder setIncludeExtractEmbedded(String includeExtractEmbeddedPattern) {
            this.includeExtractEmbeddedPattern = includeExtractEmbeddedPattern;
            return this;
        }

        public Builder setExcludeExtractEmbedded(String excludeExtractEmbeddedPattern) {
            this.excludeExtractEmbeddedPattern = excludeExtractEmbeddedPattern;
            return this;
        }

        public boolean isExtractEmbedded() {
            return this.extractEmbedded;
        }

        public String getIncludeExtractEmbeddedPattern() {
            return this.includeExtractEmbeddedPattern;
        }

        public String getExcludeExtractEmbeddedPattern() {
            return this.excludeExtractEmbeddedPattern;
        }

        public ParseTask build() {
            Objects.requireNonNull(this.name, () -> "name cannot be null");
            Objects.requireNonNull(this.parser, () -> "parser cannot be null");
            Objects.requireNonNull(this.streamFactory, () -> "streamFactory cannot be null");
            Objects.requireNonNull(this.parsedContentStrategy, () -> "parsedContentStrategy cannot be null");
            if (this.extractEmbedded) {
                Objects.requireNonNull(this.embeddedContentStrategy, () -> "embeddedContentStrategy cannot be null");
                Objects.requireNonNull(this.includeExtractEmbeddedPattern, () -> "includeExtractEmbeddedPattern cannot be null");
                Objects.requireNonNull(this.excludeExtractEmbeddedPattern, () -> "excludeExtractEmbeddedPattern cannot be null");
            }
            Objects.requireNonNull(this.metadataParser, () -> "metadataParser cannot be null");
            Objects.requireNonNull(this.parseContextFactory, () -> "parseContextFactory cannot be null");
            return new ParseTask(this.name, this.parser, this.streamFactory, this.parsedContentStrategy, this.embeddedContentStrategy, this.extractEmbedded, this.includeExtractEmbeddedPattern, this.excludeExtractEmbeddedPattern, this.metadataParser, this.parseContextFactory);
        }
    }
}

