/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.StreamFactory;
import com.github.euler.core.Item;
import com.github.euler.core.ItemProcessor;
import com.github.euler.core.ProcessingContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MimeTypeItemProcessor
implements ItemProcessor {
    private final StreamFactory sf;
    private final Detector detector;

    public MimeTypeItemProcessor(StreamFactory sf, Detector detector) {
        this.sf = sf;
        this.detector = detector;
    }

    public ProcessingContext process(Item item) {
        Object mimeType = null;
        Boolean isDirectory = (Boolean)item.ctx.metadata("is-directory");
        if (isDirectory != null && isDirectory.booleanValue()) {
            mimeType = "text/directory";
        } else {
            Metadata metadata = new Metadata();
            if (item.ctx.metadata().containsKey("name")) {
                metadata.set("resourceName", item.ctx.metadata("name").toString());
            }
            try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)this.sf.openInputStream(item.itemURI));){
                MediaType type = this.detector.detect((InputStream)tikaInputStream, metadata);
                type = type.getBaseType();
                mimeType = type.getType() + "/" + type.getSubtype();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ProcessingContext.builder().metadata("mime-type", mimeType).build();
    }
}

