/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.common.Batch;
import com.github.euler.common.BatchListener;
import com.github.euler.core.Flush;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.MetadataBatchSink;
import com.github.euler.tika.MetadataBatchState;
import com.github.euler.tika.SinkItemResponse;
import com.github.euler.tika.SinkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBatch
implements Batch {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBatch.class);
    private final MetadataBatchSink sink;
    private MetadataBatchState state;

    public MetadataBatch(MetadataBatchSink sink) {
        this.sink = sink;
        this.state = new MetadataBatchState();
    }

    public void process(JobTaskToProcess msg, BatchListener listener) {
        SinkResponse response = this.sink.store(msg.itemURI, msg.ctx);
        this.state.itemProcessed(response.getId(), msg);
        this.handleResponse(response, listener);
    }

    protected void handleResponse(SinkResponse response, BatchListener listener) {
        for (SinkItemResponse itemResponse : response.getResponses()) {
            if (itemResponse.isFailed()) {
                Exception e = itemResponse.getFailureCause();
                LOGGER.warn("Sink operation failed.", (Throwable)e);
            }
            String id = itemResponse.getId();
            JobTaskToProcess msg = this.state.getMessage(id);
            listener.finished(msg.itemURI, ProcessingContext.EMPTY);
            this.state.finish(id);
        }
    }

    public void flush(Flush msg, BatchListener listener) {
        SinkResponse response = this.sink.flush(msg.force);
        this.handleResponse(response, listener);
    }

    public void finish() {
        this.sink.finish();
    }
}

