/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.JobTaskToProcess;
import java.util.HashMap;
import java.util.Map;

public class FragmentBatchState {
    private Map<String, State> control = new HashMap<String, State>();
    private Map<String, String> mapping = new HashMap<String, String>();

    public void itemStored(String id, JobTaskToProcess msg) {
        this.control.put(id, new State(msg));
    }

    public void itemParsed(String id) {
        this.control.get((Object)id).parsed = true;
    }

    public void fragmentStored(String id, String fragId) {
        ++this.control.get((Object)id).fragments;
        this.mapping.put(fragId, id);
    }

    public boolean itemIndexed(String id) {
        State state;
        String parentId = this.mapping.get(id);
        if (parentId == null) {
            state = this.control.get(id);
            state.indexed = true;
        } else {
            state = this.control.get(parentId);
            ++state.fragmentsIndexed;
        }
        return state.parsed && state.indexed && state.fragments == state.fragmentsIndexed;
    }

    public JobTaskToProcess getMessage(String id) {
        return this.control.get((Object)id).message;
    }

    public void finish(String id) {
        this.control.remove(id);
        this.mapping.values().removeIf(v -> v.equals(id));
    }

    public String getParent(String id) {
        if (this.control.containsKey(id)) {
            return id;
        }
        if (this.mapping.containsKey(id)) {
            return this.mapping.get(id);
        }
        return null;
    }

    private class State {
        final JobTaskToProcess message;
        boolean parsed = false;
        boolean indexed = false;
        int fragments = 0;
        int fragmentsIndexed = 0;

        public State(JobTaskToProcess message) {
            this.message = message;
        }
    }
}

