/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.MetadataFieldParser;
import com.github.euler.tika.MetadataParser;
import com.github.euler.tika.StringMetadataFieldParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tika.metadata.Metadata;

public class DefaultMetadataParser
implements MetadataParser {
    private List<MetadataFieldParser> fieldParsers = new ArrayList<MetadataFieldParser>();

    public DefaultMetadataParser() {
        this.add(new StringMetadataFieldParser());
    }

    public DefaultMetadataParser(List<MetadataFieldParser> fieldParsers) {
        this.fieldParsers = new ArrayList<MetadataFieldParser>(fieldParsers);
    }

    public DefaultMetadataParser add(MetadataFieldParser fieldParser) {
        this.fieldParsers.add(fieldParser);
        return this;
    }

    @Override
    public ProcessingContext parse(Metadata metadata) {
        ProcessingContext.Builder builder = ProcessingContext.builder();
        for (String name : metadata.names()) {
            this.parseField(metadata, builder, name);
        }
        return builder.build();
    }

    protected void parseField(Metadata metadata, ProcessingContext.Builder builder, String name) {
        Object value = this.parseValue(metadata, name);
        builder.metadata(name, value);
    }

    protected Object parseValue(Metadata metadata, String name) {
        MetadataFieldParser fieldParser = this.findFieldParser(name, metadata);
        if (fieldParser == null) {
            throw new IllegalStateException("Could not find a field parser for '" + name + "'.");
        }
        Object value = fieldParser.parse(name, metadata);
        return value;
    }

    protected MetadataFieldParser findFieldParser(String name, Metadata metadata) {
        MetadataFieldParser parser = null;
        Iterator<MetadataFieldParser> iterator = this.fieldParsers.iterator();
        while (parser == null || iterator.hasNext()) {
            MetadataFieldParser next = iterator.next();
            if (!next.accept(name, metadata)) continue;
            parser = next;
        }
        return parser;
    }
}

