/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.tika.EmbeddedItemListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbeddedItemExtractor
implements EmbeddedDocumentExtractor {
    private final EmbeddedItemListener listener;
    private final boolean parseEmbedded;

    public EmbeddedItemExtractor(EmbeddedItemListener listener, boolean parseEmbedded) {
        this.listener = listener;
        this.parseEmbedded = parseEmbedded;
    }

    public boolean shouldParseEmbedded(Metadata metadata) {
        return this.parseEmbedded;
    }

    public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        String resourceName = metadata.get("resourceName");
        if (resourceName != null) {
            handler.characters(resourceName.toCharArray(), 0, resourceName.length());
            if (outputHtml) {
                handler.startElement("http://www.w3.org/1999/xhtml", "br", "br", new AttributesImpl());
                handler.endElement("http://www.w3.org/1999/xhtml", "br", "br");
            }
        }
        if (this.listener != null) {
            this.listener.newEmbedded(stream, metadata);
        }
    }
}

