/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.github.euler.common.CommonContext;
import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.EmbeddedItemFound;
import com.github.euler.core.JobTaskFinished;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.TaskCommand;
import com.github.euler.tika.EmbeddedItemListener;
import com.github.euler.tika.MetadataParser;
import com.github.euler.tika.ParseContextFactory;
import com.github.euler.tika.ParseContextFactoryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParseExecution
extends AbstractBehavior<TaskCommand>
implements EmbeddedItemListener {
    private final Parser parser;
    private final StreamFactory sf;
    private final StorageStrategy parsedContentStrategy;
    private final StorageStrategy embeddedContentStrategy;
    private final MetadataParser metadataParser;
    private final ParseContextFactory parseContextFactory;
    private JobTaskToProcess currentMsg;
    private int embeddedCounter = 0;

    public static Behavior<TaskCommand> create(Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, boolean extractEmbedded, String includeExtractEmbeddedPattern, String excludeExtractEmbeddedPattern, MetadataParser metadataParser, ParseContextFactory parseContextFactory) {
        return Behaviors.setup((Function & Serializable)context -> new ParseExecution((ActorContext<TaskCommand>)context, parser, sf, parsedContentStrategy, embeddedContentStrategy, extractEmbedded, includeExtractEmbeddedPattern, excludeExtractEmbeddedPattern, metadataParser, parseContextFactory));
    }

    protected ParseExecution(ActorContext<TaskCommand> context, Parser parser, StreamFactory sf, StorageStrategy parsedContentStrategy, StorageStrategy embeddedContentStrategy, boolean extractEmbedded, String includeExtractEmbeddedPattern, String excludeExtractEmbeddedPattern, MetadataParser metadataParser, ParseContextFactory parseContextFactory) {
        super(context);
        this.parser = parser;
        this.sf = sf;
        this.parsedContentStrategy = parsedContentStrategy;
        this.embeddedContentStrategy = embeddedContentStrategy;
        this.metadataParser = metadataParser;
        this.parseContextFactory = new ParseContextFactoryWrapper(parseContextFactory, this, extractEmbedded, includeExtractEmbeddedPattern, excludeExtractEmbeddedPattern);
    }

    public Receive<TaskCommand> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        builder.onMessage(JobTaskToProcess.class, this::onJobTaskToProcess);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Behavior<TaskCommand> onJobTaskToProcess(JobTaskToProcess msg) throws IOException, SAXException, TikaException {
        this.currentMsg = msg;
        ProcessingContext.Builder builder = ProcessingContext.builder();
        URI parsedContent = this.createParsedContent(msg.itemURI);
        builder.context(CommonContext.PARSED_CONTENT_FILE, (Object)parsedContent);
        InputStream in = null;
        Writer out = null;
        try {
            in = this.sf.openInputStream(msg.itemURI);
            out = new OutputStreamWriter(this.sf.openOutputStream(parsedContent), "utf-8");
            ProcessingContext parsed = this.parse(in, out, msg.ctx);
            ProcessingContext ctx = msg.ctx.merge(builder.build()).merge(parsed);
            msg.replyTo.tell((Object)new JobTaskFinished(msg, ctx));
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return this;
    }

    protected ProcessingContext parse(InputStream in, Writer out, ProcessingContext ctx) throws IOException, SAXException, TikaException {
        Metadata metadata = new Metadata();
        this.embeddedCounter = 0;
        ParseContext parseContext = this.parseContextFactory.create(ctx);
        this.parser.parse(in, (ContentHandler)new BodyContentHandler(out), metadata, parseContext);
        return this.metadataParser.parse(metadata);
    }

    private URI createParsedContent(URI itemURI) throws IOException {
        return this.parsedContentStrategy.createFile(itemURI);
    }

    @Override
    public void newEmbedded(InputStream in, Metadata metadata) {
        Object resourceName = metadata.get("resourceName");
        if (resourceName == null) {
            resourceName = "embedded_" + this.embeddedCounter;
        }
        URI tempFile = this.embeddedContentStrategy.createFile(".tmp");
        try (OutputStream out = this.sf.openOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ProcessingContext ctx = ProcessingContext.builder().metadata("created-datetime", (Object)metadata.getDate(TikaCoreProperties.CREATED)).metadata("last-modified-datetime", (Object)metadata.getDate(TikaCoreProperties.MODIFIED)).metadata("name", (Object)FilenameUtils.getName((String)resourceName)).context(CommonContext.TEMPORARY_URI, (Object)tempFile).setAction(ProcessingContext.Action.OVERWRITE).build();
        this.currentMsg.replyTo.tell((Object)new EmbeddedItemFound(this.currentMsg, ctx));
    }
}

