/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import com.github.euler.core.ProcessingContext;
import com.github.euler.tika.EmbeddedItemExtractor;
import com.github.euler.tika.EmbeddedItemListener;
import com.github.euler.tika.ParseContextFactory;
import java.util.regex.Pattern;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.parser.ParseContext;

public class ParseContextFactoryWrapper
implements ParseContextFactory {
    private final ParseContextFactory wrapped;
    private final EmbeddedItemListener listener;
    private final boolean parseEmbedded;
    private final Pattern includeExtractEmbeddedPattern;
    private final Pattern excludeExtractEmbeddedPattern;

    public ParseContextFactoryWrapper(ParseContextFactory wrapped, EmbeddedItemListener listener, boolean parseEmbedded, String includeExtractEmbeddedPattern, String excludeExtractEmbeddedPattern) {
        this.wrapped = wrapped;
        this.listener = listener;
        this.parseEmbedded = parseEmbedded;
        this.includeExtractEmbeddedPattern = Pattern.compile(includeExtractEmbeddedPattern);
        this.excludeExtractEmbeddedPattern = Pattern.compile(excludeExtractEmbeddedPattern);
    }

    @Override
    public ParseContext create(ProcessingContext processingContext) {
        ParseContext ctx = this.wrapped.create(processingContext);
        boolean includeEmbedded = this.includeEmbedded(processingContext);
        EmbeddedItemExtractor extractor = new EmbeddedItemExtractor(this.listener, this.parseEmbedded && includeEmbedded);
        ctx.set(EmbeddedDocumentExtractor.class, (Object)extractor);
        return ctx;
    }

    public boolean includeEmbedded(ProcessingContext ctx) {
        Object category = ctx.metadata("category");
        if (category != null) {
            boolean included = this.includeExtractEmbeddedPattern.matcher(category.toString()).matches();
            boolean excluded = this.excludeExtractEmbeddedPattern.matcher(category.toString()).matches();
            return included && !excluded;
        }
        return true;
    }
}

