/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.tika;

import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.JobTaskFinished;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.TaskCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MimeTypeDetectExecution
extends AbstractBehavior<TaskCommand> {
    private final StreamFactory sf;
    private final Detector detector;

    public static Behavior<TaskCommand> create(StreamFactory sf, Detector detector) {
        return Behaviors.setup((Function & Serializable)context -> new MimeTypeDetectExecution((ActorContext<TaskCommand>)context, sf, detector));
    }

    public MimeTypeDetectExecution(ActorContext<TaskCommand> context, StreamFactory sf, Detector detector) {
        super(context);
        this.sf = sf;
        this.detector = detector;
    }

    public Receive<TaskCommand> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        builder.onMessage(JobTaskToProcess.class, this::onJobTaskToProcess);
        return builder.build();
    }

    protected Behavior<TaskCommand> onJobTaskToProcess(JobTaskToProcess msg) throws IOException {
        Object category = null;
        Boolean isDirectory = (Boolean)msg.ctx.metadata("is-directory");
        if (isDirectory != null && isDirectory.booleanValue()) {
            category = "text/directory";
        } else {
            Metadata metadata = new Metadata();
            if (msg.ctx.metadata().containsKey("name")) {
                metadata.set("resourceName", msg.ctx.metadata("name").toString());
            }
            try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)this.sf.openInputStream(msg.itemURI));){
                MediaType type = this.detector.detect((InputStream)tikaInputStream, metadata);
                type = type.getBaseType();
                category = type.getType() + "/" + type.getSubtype();
            }
        }
        ProcessingContext ctx = ProcessingContext.builder().metadata("mime-type", category).build();
        msg.replyTo.tell((Object)new JobTaskFinished(msg, ctx));
        return this;
    }
}

