/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.AbstractTask;
import com.github.euler.core.ItemProcessor;
import com.github.euler.core.ProcessingContext;
import com.github.euler.preview.EulerPreview;
import com.github.euler.preview.MediaType;
import com.github.euler.preview.PreviewContext;
import com.github.euler.preview.PreviewItemProcessor;
import com.github.euler.preview.ScalrConfig;
import java.net.URI;

public class PreviewTask
extends AbstractTask {
    private final EulerPreview preview;
    private final PreviewContext previewContext;
    private final String formatName;
    private final ScalrConfig resizeConfig;
    private final StreamFactory sf;
    private final StorageStrategy storageStrategy;

    public PreviewTask(String name, EulerPreview preview, PreviewContext previewContext, String formatName, ScalrConfig resizeConfig, StreamFactory sf, StorageStrategy storageStrategy) {
        super(name);
        this.preview = preview;
        this.previewContext = previewContext;
        this.formatName = formatName;
        this.resizeConfig = resizeConfig;
        this.sf = sf;
        this.storageStrategy = storageStrategy;
    }

    protected ItemProcessor itemProcessor() {
        return new PreviewItemProcessor(this.preview, this.previewContext, this.formatName, this.resizeConfig, this.sf, this.storageStrategy);
    }

    protected boolean accept(URI uri, URI itemURI, ProcessingContext ctx) {
        String mime = (String)ctx.metadata("mime_type", ctx.context("mime_type"));
        if (mime != null) {
            try {
                MediaType mediaType = MediaType.parse((String)mime);
                return this.preview.isSupported(mediaType);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }
}

