/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.StorageStrategy;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;

public class PreviewCacheStorageStrategy
implements StorageStrategy {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    private final File root;
    private final String suffix;
    private final int width;
    private final int height;
    private final String format;

    public PreviewCacheStorageStrategy(File root, String suffix, int width, int height, String format) {
        this.root = root;
        this.suffix = suffix;
        this.width = width;
        this.height = height;
        this.format = format;
    }

    public URI createFile(URI uri) {
        String baseName = FilenameUtils.getBaseName((String)FileUtils.toFile((URI)uri).getAbsolutePath());
        String hash = DigestUtils.md5Hex((String)FileUtils.toFile((URI)uri).getAbsolutePath()).toLowerCase();
        return this.createFile(baseName, hash, this.suffix);
    }

    public URI createFile(String suffix) {
        String baseName = UUID.randomUUID().toString();
        String hash = DigestUtils.md5Hex((String)baseName).toLowerCase();
        return this.createFile(baseName, hash, suffix);
    }

    public URI createFile(URI uri, String suffix) {
        String baseName = FilenameUtils.getBaseName((String)FileUtils.toFile((URI)uri).getAbsolutePath());
        String hash = DigestUtils.md5Hex((String)FileUtils.toFile((URI)uri).getAbsolutePath()).toLowerCase();
        return this.createFile(baseName, hash, suffix);
    }

    public URI createFile(String baseName, String hash, String suffix) {
        String fileName = this.format(baseName, hash, this.suffix);
        File dir = new File(this.root, fileName);
        dir.getParentFile().mkdirs();
        return dir.toURI();
    }

    protected String format(String fileName, String hash, String extension) {
        Map<String, String> params = Map.of("fileName", fileName, "hash", hash, "height", Integer.toString(this.height), "width", Integer.toString(this.width), "page", "0", "extension", extension);
        return PLACEHOLDER_PATTERN.matcher(this.format).replaceAll(r -> {
            String key = r.group(1);
            return params.getOrDefault(key, "undefined");
        });
    }

    public URI createFile() {
        return this.createFile(this.suffix);
    }

    public URI createFileWithName(String name) {
        File dir = new File(this.root, name);
        dir.mkdirs();
        return dir.toURI();
    }
}

