/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.configuration.AbstractTaskConfigConverter;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TasksConfigConverter;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.Task;
import com.github.euler.preview.EulerPreview;
import com.github.euler.preview.PagePreview;
import com.github.euler.preview.PreviewConfig;
import com.github.euler.preview.PreviewContext;
import com.github.euler.preview.PreviewGenerator;
import com.github.euler.preview.PreviewTask;
import com.github.euler.preview.PreviewUtils;
import com.github.euler.preview.ScalrConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;

public class PreviewTaskConfigConverter
extends AbstractTaskConfigConverter {
    public String type() {
        return "preview";
    }

    public Task convert(Config config, ConfigContext ctx, TypesConfigConverter typesConfigConverter, TasksConfigConverter tasksConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        PreviewConfig previewConfig = new PreviewConfig();
        config.getList("generators").forEach(c -> {
            PreviewGenerator g = (PreviewGenerator)typesConfigConverter.convert("preview-generator", c, ctx);
            previewConfig.add(g);
        });
        ScalrConfig resizeConfig = PreviewUtils.fromConfig(config.getConfig("resize"));
        PreviewContext previewContext = new PreviewContext();
        previewContext.set(PagePreview.class, (Object)new PagePreview(0));
        previewContext.set(ScalrConfig.class, (Object)resizeConfig);
        String name = this.getName(config, tasksConfigConverter);
        EulerPreview preview = new EulerPreview(previewConfig);
        String formatName = config.getString("format");
        StreamFactory streamFactory = (StreamFactory)ctx.getRequired(StreamFactory.class);
        StorageStrategy storageStrategy = (StorageStrategy)typesConfigConverter.convert("storage-strategy", config.getValue("storage-strategy"), ctx);
        return new PreviewTask(name, preview, previewContext, formatName, resizeConfig, streamFactory, storageStrategy);
    }

    protected Config getDefaultConfig() {
        URL resource = PreviewTaskConfigConverter.class.getClassLoader().getResource("previewtask.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

