/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.preview.AbstractPreviewGeneratorConfigConverter;
import com.github.euler.preview.PDFBoxPreviewGenerator;
import com.github.euler.preview.PreviewGenerator;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.net.URL;
import org.apache.pdfbox.rendering.ImageType;

public class PDFBoxPreviewGeneratorConfigConverter
extends AbstractPreviewGeneratorConfigConverter {
    public String configType() {
        return "pdf";
    }

    public PreviewGenerator convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = this.getConfig(config);
        PDFBoxPreviewGenerator.Config pdfConfig = new PDFBoxPreviewGenerator.Config();
        pdfConfig.setDpi((float)config.getInt("dpi"));
        pdfConfig.setInitialPage(config.getInt("initial-page"));
        pdfConfig.setMaxPages(config.getInt("max-pages"));
        pdfConfig.setImageType((ImageType)config.getEnum(ImageType.class, "image-type"));
        return new PDFBoxPreviewGenerator(pdfConfig);
    }

    protected Config getConfig(Config config) {
        return ConfigFactory.parseString((String)config.root().render(ConfigRenderOptions.concise())).withFallback((ConfigMergeable)this.getDefaultConfig()).resolve();
    }

    protected Config getDefaultConfig() {
        URL resource = PDFBoxPreviewGeneratorConfigConverter.class.getClassLoader().getResource("pdfpreviewgenerator.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

