/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.preview.AbstractPreviewGeneratorConfigConverter;
import com.github.euler.preview.ImagePreviewGenerator;
import com.github.euler.preview.PreviewGenerator;
import com.github.euler.preview.PreviewUtils;
import com.github.euler.preview.ScalrConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.net.URL;

public class ImagePreviewGeneratorConfigConverter
extends AbstractPreviewGeneratorConfigConverter {
    public String configType() {
        return "image";
    }

    public PreviewGenerator convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = this.getConfig(config);
        ScalrConfig scalrConfig = PreviewUtils.fromConfig(config);
        return new ImagePreviewGenerator(scalrConfig);
    }

    protected Config getConfig(Config config) {
        return ConfigFactory.parseString((String)config.root().render(ConfigRenderOptions.concise())).withFallback((ConfigMergeable)this.getDefaultConfig()).resolve();
    }

    protected Config getDefaultConfig() {
        URL resource = ImagePreviewGeneratorConfigConverter.class.getClassLoader().getResource("imagepreviewgenerator.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

