/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.StorageStrategy;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;

public class PreviewCacheStorageStrategy
implements StorageStrategy {
    private final File root;
    private final String suffix;
    private final int width;
    private final int height;

    public PreviewCacheStorageStrategy(File root, String suffix, int width, int height) {
        this.root = root;
        this.suffix = suffix;
        this.width = width;
        this.height = height;
    }

    public URI createFile(URI uri) {
        String baseName = FilenameUtils.getBaseName((String)FileUtils.toFile((URI)uri).getAbsolutePath());
        String hash = DigestUtils.md5Hex((String)FileUtils.toFile((URI)uri).getAbsolutePath()).toLowerCase();
        return this.createFile(baseName, hash, this.suffix);
    }

    public URI createFile(String suffix) {
        String baseName = UUID.randomUUID().toString();
        String hash = DigestUtils.md5Hex((String)baseName).toLowerCase();
        return this.createFile(baseName, hash, suffix);
    }

    public URI createFile(URI uri, String suffix) {
        String baseName = FilenameUtils.getBaseName((String)FileUtils.toFile((URI)uri).getAbsolutePath());
        String hash = DigestUtils.md5Hex((String)FileUtils.toFile((URI)uri).getAbsolutePath()).toLowerCase();
        return this.createFile(baseName, hash, suffix);
    }

    public URI createFile(String baseName, String hash, String suffix) {
        String fileName = baseName + "-" + this.height + "x" + this.width + "-" + hash + suffix;
        File dir = new File(this.root, fileName);
        dir.mkdirs();
        return dir.toURI();
    }

    public URI createFile() {
        return this.createFile(this.suffix);
    }

    public URI createFileWithName(String name) {
        File dir = new File(this.root, name);
        dir.mkdirs();
        return dir.toURI();
    }
}

